/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.rest.service;

import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.internal.dynamicconfig.ConfigurationService;
import com.hazelcast.internal.rest.exception.ObjectNotFoundException;
import com.hazelcast.internal.rest.model.MemberDetailModel;
import com.hazelcast.internal.rest.model.SetMemberListResultModel;
import com.hazelcast.internal.rest.util.MemberUtil;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.async.DeferredResult;

@Service
public class MemberService {
    private final NodeEngineImpl nodeEngine;

    @Lazy
    public MemberService(NodeEngineImpl nodeEngine) {
        this.nodeEngine = nodeEngine;
    }

    public List<MemberDetailModel> getMembers() {
        return MemberUtil.getMembers(this.nodeEngine);
    }

    public MemberDetailModel getCurrentMember() {
        Member localMember = this.nodeEngine.getClusterService().getLocalMember();
        return new MemberDetailModel(String.valueOf(localMember.getAddress()), localMember.isLiteMember(), localMember.localMember(), String.valueOf(localMember.getUuid()), String.valueOf(localMember.getVersion()));
    }

    public MemberDetailModel getMemberWithUuid(UUID uuid) {
        MemberImpl member = this.nodeEngine.getClusterService().getMember(uuid);
        if (member != null) {
            return new MemberDetailModel(String.valueOf(member.getAddress()), member.isLiteMember(), member.localMember(), String.valueOf(member.getUuid()), String.valueOf(member.getVersion()));
        }
        throw new ObjectNotFoundException("Member could not be found with the UUID: " + String.valueOf(uuid));
    }

    public DeferredResult<SetMemberListResultModel> setMemberList(List<String> memberList) {
        ConfigurationService configurationService = (ConfigurationService)this.nodeEngine.getService("hz:configurationService");
        CompletableFuture updateFuture = configurationService.updateTcpIpConfigMemberListAsync(memberList);
        DeferredResult<SetMemberListResultModel> result = new DeferredResult<SetMemberListResultModel>();
        updateFuture.whenComplete((Void2, throwable) -> {
            if (throwable != null) {
                result.setErrorResult(throwable);
            } else {
                boolean persistenceEnabled = this.nodeEngine.getConfig().getDynamicConfigurationConfig().isPersistenceEnabled();
                result.setResult(new SetMemberListResultModel(persistenceEnabled, memberList));
            }
        });
        return result;
    }
}

