/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.rest.service;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.instance.impl.NodeState;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.internal.rest.constant.HealthCheck;
import com.hazelcast.internal.rest.model.MemberHealthModel;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.util.List;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class HealthService {
    private final NodeEngineImpl nodeEngine;

    @Lazy
    public HealthService(NodeEngineImpl nodeEngine) {
        this.nodeEngine = nodeEngine;
    }

    public MemberHealthModel memberHealth(List<HealthCheck> healthCheckList) {
        MemberHealthModel health = new MemberHealthModel();
        if (healthCheckList.isEmpty() || healthCheckList.contains((Object)HealthCheck.NODE_STATE)) {
            NodeState nodeState = this.nodeEngine.getNode().getState();
            health.setNodeState(nodeState.toString());
        }
        if (healthCheckList.isEmpty() || healthCheckList.contains((Object)HealthCheck.CLUSTER_STATE)) {
            ClusterState clusterState = this.nodeEngine.getNode().getClusterService().getClusterState();
            health.setClusterState(clusterState.toString());
        }
        if (healthCheckList.isEmpty() || healthCheckList.contains((Object)HealthCheck.NUMBER_OF_MEMBERS)) {
            ClusterServiceImpl clusterService = this.nodeEngine.getNode().getClusterService();
            health.setNumberOfMembers(clusterService.getMembers().size());
        }
        if (healthCheckList.contains((Object)HealthCheck.MEMBER_SAFE)) {
            health.setMemberSafe(this.isMemberSafe());
        }
        return health;
    }

    public boolean memberReady() {
        return this.nodeEngine.getNode().isRunning() && this.nodeEngine.getNode().getNodeExtension().isReady();
    }

    private boolean isMemberSafe() {
        InternalPartitionService partitionService = this.nodeEngine.getNode().getPartitionService();
        boolean memberStateSafe = partitionService.isMemberStateSafe();
        return memberStateSafe && !partitionService.hasOnGoingMigration();
    }
}

