/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.rest.security;

import com.hazelcast.internal.json.Json;
import com.hazelcast.internal.json.JsonValue;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.security.Keys;
import java.time.Duration;
import java.util.Date;
import java.util.stream.StreamSupport;
import javax.crypto.SecretKey;
import org.springframework.stereotype.Component;

@Component
public class JwtTokenUtil {
    private final SecretKey secretKey = this.generateSecretKey();

    private SecretKey generateSecretKey() {
        return Keys.secretKeyFor(SignatureAlgorithm.HS256);
    }

    public String generateToken(Duration ttl, String[] principalNames) {
        return Jwts.builder().claim("roles", Json.array((String[])principalNames).toString()).issuedAt(new Date(System.currentTimeMillis())).expiration(new Date(System.currentTimeMillis() + ttl.toMillis())).signWith(this.secretKey).compact();
    }

    public Claims parseToken(String token) {
        return (Claims)Jwts.parser().verifyWith(this.secretKey).build().parseSignedClaims(token).getPayload();
    }

    public static String[] parseRolesClaim(Claims claims) {
        return (String[])StreamSupport.stream(Json.parse((String)claims.get("roles", String.class)).asArray().spliterator(), false).map(JsonValue::asString).toArray(String[]::new);
    }
}

