/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.rest.security;

import com.hazelcast.access.AccessControlService;
import com.hazelcast.internal.rest.security.JwtAuthFilter;
import com.hazelcast.internal.rest.security.JwtTokenUtil;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
public class JwtAuthFilterConfig {
    private final AccessControlService accessControlService;
    private final JwtTokenUtil tokenUtil;

    public JwtAuthFilterConfig(@Lazy AccessControlService accessControlService, JwtTokenUtil tokenUtil) {
        this.accessControlService = accessControlService;
        this.tokenUtil = tokenUtil;
    }

    @Bean
    public FilterRegistrationBean<JwtAuthFilter> loggingFilter() {
        FilterRegistrationBean<JwtAuthFilter> registrationBean = new FilterRegistrationBean<JwtAuthFilter>();
        registrationBean.setFilter(new JwtAuthFilter(this.accessControlService, this.tokenUtil));
        registrationBean.addUrlPatterns("/hazelcast/rest/api/v1/*");
        return registrationBean;
    }
}

