/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.rest.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.internal.rest.model.CustomWanPublisherConfigModel;
import com.hazelcast.internal.rest.model.WanBatchPublisherConfigModel;
import com.hazelcast.internal.rest.model.WanConsumerConfigModel;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Collections;
import java.util.List;

@Schema(description="WAN replication configuration")
@JsonIgnoreProperties(ignoreUnknown=true)
public class WanReplicationConfigModel {
    @Schema(description="Name of the WAN replication configuration")
    @NotNull
    private String name;
    @Schema(description="WAN consumer configuration")
    private WanConsumerConfigModel consumer;
    @Schema(description="List of WAN batch publisher configurations")
    private List<WanBatchPublisherConfigModel> batchPublishers;
    @Schema(description="List of custom WAN publisher configurations")
    private List<CustomWanPublisherConfigModel> customPublishers;

    public WanReplicationConfigModel() {
        this.batchPublishers = Collections.emptyList();
        this.customPublishers = Collections.emptyList();
    }

    public WanReplicationConfigModel(String name, WanConsumerConfigModel consumer, List<WanBatchPublisherConfigModel> batchPublishers, List<CustomWanPublisherConfigModel> customPublishers) {
        this.name = name;
        this.consumer = consumer;
        this.batchPublishers = batchPublishers;
        this.customPublishers = customPublishers;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setConsumer(WanConsumerConfigModel consumer) {
        this.consumer = consumer;
    }

    public void setBatchPublishers(List<WanBatchPublisherConfigModel> batchPublishers) {
        this.batchPublishers = batchPublishers;
    }

    public void setCustomPublishers(List<CustomWanPublisherConfigModel> customPublishers) {
        this.customPublishers = customPublishers;
    }

    public WanReplicationConfig toWanReplicationConfig() {
        WanReplicationConfig wanReplicationConfig = new WanReplicationConfig();
        wanReplicationConfig.setName(this.name);
        if (this.consumer != null) {
            wanReplicationConfig.setConsumerConfig(this.consumer.toWanConsumerConfig());
        }
        if (this.batchPublishers != null) {
            this.batchPublishers.forEach(batchPublisher -> wanReplicationConfig.addBatchReplicationPublisherConfig(batchPublisher.toWanBatchPublisherConfig()));
        }
        if (this.customPublishers != null) {
            this.customPublishers.forEach(customPublisher -> wanReplicationConfig.addCustomPublisherConfig(customPublisher.toCustomWanPublisherConfig()));
        }
        return wanReplicationConfig;
    }

    public WanConsumerConfigModel getConsumer() {
        return this.consumer;
    }

    public List<WanBatchPublisherConfigModel> getBatchPublishers() {
        return this.batchPublishers;
    }

    public List<CustomWanPublisherConfigModel> getCustomPublishers() {
        return this.customPublishers;
    }
}

