/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.rest.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.hazelcast.config.AwsConfig;
import com.hazelcast.config.AzureConfig;
import com.hazelcast.config.EurekaConfig;
import com.hazelcast.config.GcpConfig;
import com.hazelcast.config.KubernetesConfig;
import com.hazelcast.config.WanAcknowledgeType;
import com.hazelcast.config.WanBatchPublisherConfig;
import com.hazelcast.config.WanQueueFullBehavior;
import com.hazelcast.internal.rest.model.AliasedDiscoveryConfigModel;
import com.hazelcast.internal.rest.model.DiscoveryConfigModel;
import com.hazelcast.internal.rest.model.WanSyncConfigModel;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.wan.WanPublisherState;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collections;
import java.util.Map;

@Schema(description="WAN batch publisher configuration. DTP representation of WanBatchPublisherConfig.")
@JsonIgnoreProperties(ignoreUnknown=true)
public class WanBatchPublisherConfigModel {
    private String clusterName;
    private String publisherId;
    private int batchSize = 500;
    private int batchMaxDelayMillis = 1000;
    private int responseTimeoutMillis = 60000;
    private WanAcknowledgeType acknowledgeType = WanBatchPublisherConfig.DEFAULT_ACKNOWLEDGE_TYPE;
    private WanPublisherState initialPublisherState = WanBatchPublisherConfig.DEFAULT_INITIAL_PUBLISHER_STATE;
    private boolean snapshotEnabled = false;
    private long idleMinParkNs = WanBatchPublisherConfig.DEFAULT_IDLE_MIN_PARK_NS;
    private long idleMaxParkNs = WanBatchPublisherConfig.DEFAULT_IDLE_MAX_PARK_NS;
    private int maxConcurrentInvocations = -1;
    private int discoveryPeriodSeconds = 10;
    private boolean useEndpointPrivateAddress = false;
    private WanQueueFullBehavior queueFullBehavior = WanBatchPublisherConfig.DEFAULT_QUEUE_FULL_BEHAVIOUR;
    private int maxTargetEndpoints = Integer.MAX_VALUE;
    private int queueCapacity = 10000;
    private String targetEndpoints = "";
    private AliasedDiscoveryConfigModel aws;
    private AliasedDiscoveryConfigModel gcp;
    private AliasedDiscoveryConfigModel azure;
    private AliasedDiscoveryConfigModel kubernetes;
    private AliasedDiscoveryConfigModel eureka;
    private DiscoveryConfigModel discovery;
    private String endpoint;
    private Map<String, String> properties;
    private WanSyncConfigModel sync;

    public WanBatchPublisherConfigModel(String clusterName, String publisherId, int batchSize, int batchMaxDelayMillis, int responseTimeoutMillis, WanAcknowledgeType acknowledgeType, WanPublisherState initialPublisherState, boolean snapshotEnabled, long idleMinParkNs, long idleMaxParkNs, int maxConcurrentInvocations, int discoveryPeriodSeconds, boolean useEndpointPrivateAddress, WanQueueFullBehavior queueFullBehavior, int maxTargetEndpoints, int queueCapacity, String targetEndpoints, AliasedDiscoveryConfigModel aws, AliasedDiscoveryConfigModel gcp, AliasedDiscoveryConfigModel azure, AliasedDiscoveryConfigModel kubernetes, AliasedDiscoveryConfigModel eureka, DiscoveryConfigModel discovery, String endpoint, Map<String, String> properties, WanSyncConfigModel sync) {
        this.clusterName = clusterName;
        this.publisherId = publisherId;
        this.batchSize = batchSize;
        this.batchMaxDelayMillis = batchMaxDelayMillis;
        this.responseTimeoutMillis = responseTimeoutMillis;
        this.acknowledgeType = acknowledgeType;
        this.initialPublisherState = initialPublisherState;
        this.snapshotEnabled = snapshotEnabled;
        this.idleMinParkNs = idleMinParkNs;
        this.idleMaxParkNs = idleMaxParkNs;
        this.maxConcurrentInvocations = maxConcurrentInvocations;
        this.discoveryPeriodSeconds = discoveryPeriodSeconds;
        this.useEndpointPrivateAddress = useEndpointPrivateAddress;
        this.queueFullBehavior = queueFullBehavior;
        this.maxTargetEndpoints = maxTargetEndpoints;
        this.queueCapacity = queueCapacity;
        this.targetEndpoints = targetEndpoints;
        this.aws = aws;
        this.gcp = gcp;
        this.azure = azure;
        this.kubernetes = kubernetes;
        this.eureka = eureka;
        this.discovery = discovery;
        this.endpoint = endpoint;
        this.properties = properties;
        this.sync = sync;
    }

    public WanBatchPublisherConfigModel() {
        this.properties = Collections.emptyMap();
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getPublisherId() {
        return this.publisherId;
    }

    public void setPublisherId(String publisherId) {
        this.publisherId = publisherId;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getBatchMaxDelayMillis() {
        return this.batchMaxDelayMillis;
    }

    public void setBatchMaxDelayMillis(int batchMaxDelayMillis) {
        this.batchMaxDelayMillis = batchMaxDelayMillis;
    }

    public int getResponseTimeoutMillis() {
        return this.responseTimeoutMillis;
    }

    public void setResponseTimeoutMillis(int responseTimeoutMillis) {
        this.responseTimeoutMillis = responseTimeoutMillis;
    }

    public WanAcknowledgeType getAcknowledgeType() {
        return this.acknowledgeType;
    }

    public void setAcknowledgeType(WanAcknowledgeType acknowledgeType) {
        this.acknowledgeType = acknowledgeType;
    }

    public WanPublisherState getInitialPublisherState() {
        return this.initialPublisherState;
    }

    public void setInitialPublisherState(WanPublisherState initialPublisherState) {
        this.initialPublisherState = initialPublisherState;
    }

    public boolean isSnapshotEnabled() {
        return this.snapshotEnabled;
    }

    public void setSnapshotEnabled(boolean snapshotEnabled) {
        this.snapshotEnabled = snapshotEnabled;
    }

    public long getIdleMinParkNs() {
        return this.idleMinParkNs;
    }

    public void setIdleMinParkNs(long idleMinParkNs) {
        this.idleMinParkNs = idleMinParkNs;
    }

    public long getIdleMaxParkNs() {
        return this.idleMaxParkNs;
    }

    public void setIdleMaxParkNs(long idleMaxParkNs) {
        this.idleMaxParkNs = idleMaxParkNs;
    }

    public int getMaxConcurrentInvocations() {
        return this.maxConcurrentInvocations;
    }

    public void setMaxConcurrentInvocations(int maxConcurrentInvocations) {
        this.maxConcurrentInvocations = maxConcurrentInvocations;
    }

    public int getDiscoveryPeriodSeconds() {
        return this.discoveryPeriodSeconds;
    }

    public void setDiscoveryPeriodSeconds(int discoveryPeriodSeconds) {
        this.discoveryPeriodSeconds = discoveryPeriodSeconds;
    }

    public boolean isUseEndpointPrivateAddress() {
        return this.useEndpointPrivateAddress;
    }

    public void setUseEndpointPrivateAddress(boolean useEndpointPrivateAddress) {
        this.useEndpointPrivateAddress = useEndpointPrivateAddress;
    }

    public WanQueueFullBehavior getQueueFullBehavior() {
        return this.queueFullBehavior;
    }

    public void setQueueFullBehavior(WanQueueFullBehavior queueFullBehavior) {
        this.queueFullBehavior = queueFullBehavior;
    }

    public int getMaxTargetEndpoints() {
        return this.maxTargetEndpoints;
    }

    public void setMaxTargetEndpoints(int maxTargetEndpoints) {
        this.maxTargetEndpoints = maxTargetEndpoints;
    }

    public int getQueueCapacity() {
        return this.queueCapacity;
    }

    public void setQueueCapacity(int queueCapacity) {
        this.queueCapacity = queueCapacity;
    }

    public String getTargetEndpoints() {
        return this.targetEndpoints;
    }

    public void setTargetEndpoints(String targetEndpoints) {
        this.targetEndpoints = targetEndpoints;
    }

    public AliasedDiscoveryConfigModel getAws() {
        return this.aws;
    }

    public void setAws(AliasedDiscoveryConfigModel aws) {
        this.aws = aws;
    }

    public AliasedDiscoveryConfigModel getGcp() {
        return this.gcp;
    }

    public void setGcp(AliasedDiscoveryConfigModel gcp) {
        this.gcp = gcp;
    }

    public AliasedDiscoveryConfigModel getAzure() {
        return this.azure;
    }

    public void setAzure(AliasedDiscoveryConfigModel azure) {
        this.azure = azure;
    }

    public AliasedDiscoveryConfigModel getKubernetes() {
        return this.kubernetes;
    }

    public void setKubernetes(AliasedDiscoveryConfigModel kubernetes) {
        this.kubernetes = kubernetes;
    }

    public AliasedDiscoveryConfigModel getEureka() {
        return this.eureka;
    }

    public void setEureka(AliasedDiscoveryConfigModel eureka) {
        this.eureka = eureka;
    }

    public DiscoveryConfigModel getDiscovery() {
        return this.discovery;
    }

    public void setDiscovery(DiscoveryConfigModel discovery) {
        this.discovery = discovery;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public WanSyncConfigModel getSync() {
        return this.sync;
    }

    public void setSync(WanSyncConfigModel sync) {
        this.sync = sync;
    }

    public WanBatchPublisherConfig toWanBatchPublisherConfig() {
        WanBatchPublisherConfig wanBatchPublisherConfig = new WanBatchPublisherConfig();
        wanBatchPublisherConfig.setClusterName(this.clusterName);
        wanBatchPublisherConfig.setPublisherId(this.publisherId);
        wanBatchPublisherConfig.setBatchSize(this.batchSize);
        wanBatchPublisherConfig.setBatchMaxDelayMillis(this.batchMaxDelayMillis);
        wanBatchPublisherConfig.setResponseTimeoutMillis(this.responseTimeoutMillis);
        wanBatchPublisherConfig.setAcknowledgeType(this.acknowledgeType);
        wanBatchPublisherConfig.setInitialPublisherState(this.initialPublisherState);
        wanBatchPublisherConfig.setSnapshotEnabled(this.snapshotEnabled);
        wanBatchPublisherConfig.setIdleMinParkNs(this.idleMinParkNs);
        wanBatchPublisherConfig.setIdleMaxParkNs(this.idleMaxParkNs);
        wanBatchPublisherConfig.setMaxConcurrentInvocations(this.maxConcurrentInvocations);
        wanBatchPublisherConfig.setDiscoveryPeriodSeconds(this.discoveryPeriodSeconds);
        wanBatchPublisherConfig.setUseEndpointPrivateAddress(this.useEndpointPrivateAddress);
        wanBatchPublisherConfig.setQueueFullBehavior(this.queueFullBehavior);
        wanBatchPublisherConfig.setMaxTargetEndpoints(this.maxTargetEndpoints);
        wanBatchPublisherConfig.setQueueCapacity(this.queueCapacity);
        wanBatchPublisherConfig.setTargetEndpoints(this.targetEndpoints);
        if (this.aws != null) {
            wanBatchPublisherConfig.setAwsConfig((AwsConfig)this.aws.toAliasedDiscoveryConfig());
        }
        if (this.gcp != null) {
            wanBatchPublisherConfig.setGcpConfig((GcpConfig)this.gcp.toAliasedDiscoveryConfig());
        }
        if (this.azure != null) {
            wanBatchPublisherConfig.setAzureConfig((AzureConfig)this.azure.toAliasedDiscoveryConfig());
        }
        if (this.kubernetes != null) {
            wanBatchPublisherConfig.setKubernetesConfig((KubernetesConfig)this.kubernetes.toAliasedDiscoveryConfig());
        }
        if (this.eureka != null) {
            wanBatchPublisherConfig.setEurekaConfig((EurekaConfig)this.eureka.toAliasedDiscoveryConfig());
        }
        if (this.discovery != null) {
            wanBatchPublisherConfig.setDiscoveryConfig(this.discovery.toDiscoveryConfig());
        }
        wanBatchPublisherConfig.setEndpoint(this.endpoint);
        Map mapProperties = MapUtil.createHashMap((int)this.properties.size());
        this.properties.forEach((key, value) -> mapProperties.put(key, value));
        wanBatchPublisherConfig.setProperties(mapProperties);
        if (this.sync != null) {
            wanBatchPublisherConfig.setSyncConfig(this.sync.toWanSyncConfig());
        }
        return wanBatchPublisherConfig;
    }
}

