/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.rest.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.hazelcast.internal.dynamicconfig.ConfigUpdateResult;
import com.hazelcast.internal.rest.model.ConfigNamespaceModel;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.List;

@Schema(description="Result of server configuration reload.")
@JsonIgnoreProperties(ignoreUnknown=true)
public record ConfigActionResultModel(@Schema(description="Newly added configs.") Collection<ConfigNamespaceModel> addedConfigs, @Schema(description="Ignored configs, since an equal config already exist.") Collection<ConfigNamespaceModel> ignoredConfigs) {
    public static ConfigActionResultModel fromConfigUpdateResult(ConfigUpdateResult result) {
        List<ConfigNamespaceModel> addedConfigs = result.getAddedConfigs().stream().map(ConfigNamespaceModel::fromConfigNameSpace).toList();
        List<ConfigNamespaceModel> ignoredConfigs = result.getIgnoredConfigs().stream().map(ConfigNamespaceModel::fromConfigNameSpace).toList();
        return new ConfigActionResultModel(addedConfigs, ignoredConfigs);
    }
}

