/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.rest.model;

import com.hazelcast.cluster.Address;
import com.hazelcast.cp.session.CPSession;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;

public record CPSessionModel(@Schema(description="The id of the session.") long id, @Schema(description="The timestamp in epoch milliseconds of when the session was created.") long creationTime, @Schema(description="The timestamp in epoch milliseconds of when the session will expire.") long expirationTime, @Schema(description="The version of the session. A session's version is incremented on each heartbeat.") long version, @Schema(description="The endpoint that has created the session.") String endpoint, @Schema(description="The type of the endpoint that has created the session. Possible values are SERVER, CLIENT.") String endpointType, @Schema(description="The name of the endpoint that has created the session.") String endpointName) {
    public static Collection<CPSessionModel> fromCPSessions(Collection<CPSession> sessions) {
        return sessions.stream().map(CPSessionModel::fromCPSession).toList();
    }

    public static CPSessionModel fromCPSession(CPSession cpSession) {
        Address address = cpSession.endpoint();
        return new CPSessionModel(cpSession.id(), cpSession.creationTime(), cpSession.expirationTime(), cpSession.version(), "[" + address.getHost() + "]:" + address.getPort(), cpSession.endpointType().name(), cpSession.endpointName());
    }
}

