/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.rest.init;

import com.hazelcast.access.AccessControlService;
import com.hazelcast.config.rest.RestConfig;
import com.hazelcast.internal.config.service.impl.EnterpriseConfigFileService;
import com.hazelcast.internal.dynamicconfig.DynamicConfigurationAwareConfig;
import com.hazelcast.internal.rest.HazelcastRestSpringApplication;
import com.hazelcast.internal.services.ManagedService;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.security.impl.SecurityContextImpl;
import com.hazelcast.spi.impl.NodeEngine;
import java.util.Properties;
import javax.annotation.Nullable;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.actuate.metrics.MetricsEndpoint;
import org.springframework.context.ConfigurableApplicationContext;

public class RestServiceImpl
implements ManagedService {
    public static final String SERVICE_NAME = "hz:impl:restServiceImpl";
    private volatile ConfigurableApplicationContext context;
    private volatile boolean isEnabled;

    public RestServiceImpl(NodeEngine nodeEngine) {
        this.startService(nodeEngine);
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Nullable
    public MetricsEndpoint getMetricsEndpoint() {
        return this.context != null && this.context.isActive() ? this.context.getBean(MetricsEndpoint.class) : null;
    }

    public void init(NodeEngine nodeEngine, Properties properties) {
    }

    public void reset() {
    }

    public void shutdown(boolean terminate) {
        if (this.context != null) {
            this.context.close();
        }
    }

    public void startService(NodeEngine nodeEngine) {
        RestConfig restConfig = this.getRestConfig(nodeEngine);
        if (!restConfig.isEnabled()) {
            return;
        }
        this.isEnabled = restConfig.isEnabled();
        long port = restConfig.getPort();
        Properties properties = new Properties();
        properties.setProperty("server.port", String.valueOf(port));
        this.setPropertiesBasedOnSslConfig(restConfig, properties);
        SpringApplication application = new SpringApplication(HazelcastRestSpringApplication.class);
        application.setDefaultProperties(properties);
        SecurityContext securityContext = (SecurityContext)Preconditions.checkNotNull((Object)nodeEngine.getNode().securityContext, (String)"SecurityContext cannot be null. Please configure a security realm.");
        SecurityContextImpl sci = (SecurityContextImpl)securityContext;
        AccessControlService accessControlService = sci.createAccessControlServiceForRealm(restConfig.getSecurityRealm());
        assert (accessControlService != null);
        this.context = application.run(new String[0]);
        this.context.getBeanFactory().registerSingleton("restConfig", restConfig);
        this.context.getBeanFactory().registerSingleton("nodeEngine", nodeEngine);
        this.context.getBeanFactory().registerSingleton("accessControlService", accessControlService);
        this.context.getBeanFactory().registerSingleton("configFileService", new EnterpriseConfigFileService(nodeEngine.getOperationService(), nodeEngine.getClusterService(), nodeEngine.getExecutionService()));
        nodeEngine.getHazelcastInstance().getLoggingService().getLogger(RestServiceImpl.class).info("Hazelcast REST Service is enabled on port: " + port + " with security realm: " + restConfig.getSecurityRealm() + " and access control service: " + accessControlService.getClass().getName());
    }

    private void setPropertiesBasedOnSslConfig(RestConfig restConfig, Properties properties) {
        RestConfig.Ssl ssl = restConfig.getSsl();
        if (ssl.isEnabled()) {
            RestServiceImpl.setSslProperties(ssl, properties);
        }
    }

    private static void setSslProperties(RestConfig.Ssl ssl, Properties properties) {
        RestServiceImpl.setKeyStoreProperties(ssl, properties);
        RestServiceImpl.setTrustStoreProperties(ssl, properties);
        RestServiceImpl.setProtocolProperties(ssl, properties);
        RestServiceImpl.setCertificateProperties(ssl, properties);
    }

    private static void setKeyStoreProperties(RestConfig.Ssl ssl, Properties properties) {
        if (ssl.getKeyStore() != null) {
            properties.setProperty("server.ssl.key-store", ssl.getKeyStore());
        }
        if (ssl.getKeyStorePassword() != null) {
            properties.setProperty("server.ssl.key-store-password", ssl.getKeyStorePassword());
        }
        if (ssl.getKeyPassword() != null) {
            properties.setProperty("server.ssl.key-password", ssl.getKeyPassword());
        }
        if (ssl.getKeyStoreType() != null) {
            properties.setProperty("server.ssl.key-store-type", ssl.getKeyStoreType());
        }
        if (ssl.getKeyAlias() != null) {
            properties.setProperty("server.ssl.key-alias", ssl.getKeyAlias());
        }
    }

    private static void setTrustStoreProperties(RestConfig.Ssl ssl, Properties properties) {
        if (ssl.getTrustStore() != null) {
            properties.setProperty("server.ssl.trust-store", ssl.getTrustStore());
        }
        if (ssl.getTrustStorePassword() != null) {
            properties.setProperty("server.ssl.trust-store-password", ssl.getTrustStorePassword());
        }
        if (ssl.getTrustStoreType() != null) {
            properties.setProperty("server.ssl.trust-store-type", ssl.getTrustStoreType());
        }
        if (ssl.getKeyStoreProvider() != null) {
            properties.setProperty("server.ssl.key-store-provider", ssl.getKeyStoreProvider());
        }
    }

    private static void setProtocolProperties(RestConfig.Ssl ssl, Properties properties) {
        if (ssl.getClientAuth() != null) {
            properties.setProperty("server.ssl.client-auth", ssl.getClientAuth().name());
        }
        if (ssl.getEnabledProtocols() != null) {
            properties.setProperty("server.ssl.enabled-protocols", ssl.getEnabledProtocols());
        }
        if (ssl.getCiphers() != null) {
            properties.setProperty("server.ssl.ciphers", ssl.getCiphers());
        }
        if (ssl.getProtocol() != null) {
            properties.setProperty("server.ssl.protocol", ssl.getProtocol());
        }
    }

    private static void setCertificateProperties(RestConfig.Ssl ssl, Properties properties) {
        if (ssl.getCertificate() != null) {
            properties.setProperty("server.ssl.certificate", ssl.getCertificate());
        }
        if (ssl.getCertificatePrivateKey() != null) {
            properties.setProperty("server.ssl.certificate-private-key", ssl.getCertificatePrivateKey());
        }
        if (ssl.getTrustCertificate() != null) {
            properties.setProperty("server.ssl.trust-certificate", ssl.getTrustCertificate());
        }
        if (ssl.getTrustCertificatePrivateKey() != null) {
            properties.setProperty("server.ssl.trust-certificate-private-key", ssl.getTrustCertificatePrivateKey());
        }
    }

    private RestConfig getRestConfig(NodeEngine nodeEngine) {
        DynamicConfigurationAwareConfig config = (DynamicConfigurationAwareConfig)nodeEngine.getConfig();
        return config.getStaticConfig().getRestConfig();
    }
}

