/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.rest.controller;

import com.hazelcast.internal.rest.model.AddWanConfigResultModel;
import com.hazelcast.internal.rest.model.StatusCodeAndMessage;
import com.hazelcast.internal.rest.model.WanReplicationConfigModel;
import com.hazelcast.internal.rest.model.WanSyncResultModel;
import com.hazelcast.internal.rest.model.WanSyncStatusModel;
import com.hazelcast.internal.rest.service.WanService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.util.UUID;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/hazelcast/rest/api/v1/wan"})
@Validated
public class WanController {
    WanService wanService;

    public WanController(WanService wanService) {
        this.wanService = wanService;
    }

    @PostMapping(value={"/clear-queues/{wanReplicationName}/{publisherId}"})
    @Operation(summary="Clears WAN replication queues.", description="Removes all WAN events awaiting replication for the given wanReplicationName\nfor the given target.", tags={"WAN Controller"}, responses={@ApiResponse(responseCode="200", description="Wan replication queues has been cleared successfully."), @ApiResponse(responseCode="400", description="Wan replication configuration not found.", content={@Content(schema=@Schema(implementation=StatusCodeAndMessage.class), mediaType="application/json", examples={@ExampleObject(name="Bad Request", description="Wan replication configuration not found.", value="{\n \"statusCode\": 400,\n \"message\": \"Wan replication configuration not found.\"\n}")})})})
    ResponseEntity<Void> clearWanQueues(@PathVariable(value="wanReplicationName") @Parameter(in=ParameterIn.PATH, required=true, description="The name of the wan replication configuration") String wanReplicationName, @Parameter(in=ParameterIn.PATH, required=true, description="ID of the WAN replication publisher") @PathVariable(value="publisherId") String publisherId) {
        this.wanService.clearWanQueues(wanReplicationName, publisherId);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/stop-publisher/{wanReplicationName}/{publisherId}"})
    @Operation(summary="Stops WAN publisher.", description="Stops WAN replication for the given wanReplicationName and\nwanPublisherId on this Hazelcast instance.\nSilently skips publishers not supporting stopping.", tags={"WAN Controller"}, responses={@ApiResponse(responseCode="200", description="Wan publisher has been stopped successfully."), @ApiResponse(responseCode="400", description="Wan replication configuration not found.", content={@Content(schema=@Schema(implementation=StatusCodeAndMessage.class), mediaType="application/json", examples={@ExampleObject(name="Bad Request", description="Wan replication configuration not found.", value="{\n \"statusCode\": 400,\n \"message\": \"Wan replication configuration not found.\"\n}")})})})
    ResponseEntity<Void> stopWanPublisher(@PathVariable(value="wanReplicationName") @Parameter(in=ParameterIn.PATH, required=true, description="The name of the wan replication configuration") String wanReplicationName, @Parameter(in=ParameterIn.PATH, required=true, description="ID of the WAN replication publisher") @PathVariable(value="publisherId") String publisherId) {
        this.wanService.stopWanPublisher(wanReplicationName, publisherId);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/resume-publisher/{wanReplicationName}/{publisherId}"})
    @Operation(summary="Resumes WAN publisher.", description="Resumes WAN replication for the given wanReplicationName and wanPublisherId on this Hazelcast instance. Silently skips publishers not supporting resuming.", tags={"WAN Controller"}, responses={@ApiResponse(responseCode="200", description="Wan publisher has been resumed successfully."), @ApiResponse(responseCode="400", description="Wan replication configuration not found.", content={@Content(schema=@Schema(implementation=StatusCodeAndMessage.class), mediaType="application/json", examples={@ExampleObject(name="Bad Request", description="Wan replication configuration not found.", value="{\n \"statusCode\": 400,\n \"message\": \"Wan replication configuration not found.\"\n}")})})})
    ResponseEntity<Void> resumeWanPublisher(@PathVariable(value="wanReplicationName") @Parameter(in=ParameterIn.PATH, required=true, description="The name of the wan replication configuration") String wanReplicationName, @Parameter(in=ParameterIn.PATH, required=true, description="ID of the WAN replication publisher") @PathVariable(value="publisherId") String publisherId) {
        this.wanService.resumeWanPublisher(wanReplicationName, publisherId);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/pause-publisher/{wanReplicationName}/{publisherId}"})
    @Operation(summary="Pauses WAN publisher.", description="Pauses WAN replication for the given wanReplicationName and wanPublisherId on this Hazelcast instance. Silently skips publishers not supporting pausing.", tags={"WAN Controller"}, responses={@ApiResponse(responseCode="200", description="Wan publisher has been paused successfully."), @ApiResponse(responseCode="400", description="Wan replication configuration not found.", content={@Content(schema=@Schema(implementation=StatusCodeAndMessage.class), mediaType="application/json", examples={@ExampleObject(name="Bad Request", description="Wan replication configuration not found.", value="{\n \"statusCode\": 400,\n \"message\": \"Wan replication configuration not found.\"\n}")})})})
    ResponseEntity<Void> pauseWanPublisher(@PathVariable(value="wanReplicationName") @Parameter(in=ParameterIn.PATH, required=true, description="The name of the wan replication configuration") String wanReplicationName, @PathVariable(value="publisherId") @Parameter(in=ParameterIn.PATH, required=true, description="ID of the WAN replication publisher") String publisherId) {
        this.wanService.pauseWanPublisher(wanReplicationName, publisherId);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/sync-map/{wanReplicationName}/{publisherId}/{mapName}"})
    @Operation(summary="Initiate wan sync for a specific map.", description="Initiate wan sync for a specific map.", tags={"WAN Controller"}, responses={@ApiResponse(responseCode="200", description="UUID of the WAN sync operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=WanSyncResultModel.class), examples={@ExampleObject(name="OK", description="WAN sync map operation has been initiated successfully.", value="{\n \"syncId\": \"e7b3b3b3-4b3b-4b3b-4b3b-4b3b3b3b3b3b\"\n}")})}), @ApiResponse(responseCode="400", description="Wan replication configuration not found.", content={@Content(schema=@Schema(implementation=StatusCodeAndMessage.class), mediaType="application/json", examples={@ExampleObject(name="Bad Request", description="Wan replication configuration not found.", value="{\n \"statusCode\": 400,\n \"message\": \"Wan replication configuration not found.\"\n}")})}), @ApiResponse(responseCode="503", description="There is an ongoing anti-entropy event being processed.", content={@Content(schema=@Schema(implementation=StatusCodeAndMessage.class), mediaType="application/json", examples={@ExampleObject(name="Service Unavailable", description="if there is an ongoing anti-entropy event being processed.", value="{\n \"statusCode\": 503,\n \"message\": \"There is an ongoing anti-entropy event being processed.\"\n}")})})})
    ResponseEntity<WanSyncResultModel> syncMap(@PathVariable(value="wanReplicationName") @Parameter(in=ParameterIn.PATH, required=true, description="The name of the wan replication configuration") String wanReplicationName, @PathVariable(value="publisherId") @Parameter(in=ParameterIn.PATH, required=true, description="ID of the WAN replication publisher") String publisherId, @PathVariable(value="mapName") @Parameter(in=ParameterIn.PATH, required=true, description="The name of the map to sync") String mapName) {
        UUID syncId = this.wanService.syncMap(wanReplicationName, publisherId, mapName);
        return ResponseEntity.ok(new WanSyncResultModel(syncId.toString()));
    }

    @PostMapping(value={"/sync-all-maps/{wanReplicationName}/{publisherId}"})
    @Operation(summary="Initiate wan sync for all maps.", description="Initiate wan sync for all maps.", tags={"WAN Controller"}, responses={@ApiResponse(responseCode="200", description="WAN sync all maps operation has been initiated successfully.", content={@Content(mediaType="application/json", schema=@Schema(implementation=WanSyncResultModel.class), examples={@ExampleObject(name="OK", description="UUID of the WAN sync operation.", value="{\n \"syncId\": \"e7b3b3b3-4b3b-4b3b-4b3b-4b3b3b3b3b3b\"\n}")})}), @ApiResponse(responseCode="400", description="Wan replication configuration not found.", content={@Content(schema=@Schema(implementation=StatusCodeAndMessage.class), mediaType="application/json", examples={@ExampleObject(name="Bad Request", description="Wan replication configuration not found.", value="{\n \"statusCode\": 400,\n \"message\": \"Wan replication configuration not found.\"\n}")})})})
    ResponseEntity<WanSyncResultModel> syncAllMaps(@PathVariable(value="wanReplicationName") @Parameter(in=ParameterIn.PATH, required=true, description="The name of the wan replication configuration") String wanReplicationName, @PathVariable(value="publisherId") @Parameter(in=ParameterIn.PATH, required=true, description="ID of the WAN replication publisher") String publisherId) {
        UUID syncId = this.wanService.syncAllMaps(wanReplicationName, publisherId);
        return ResponseEntity.ok(new WanSyncResultModel(syncId.toString()));
    }

    @PostMapping(value={"/add-config"})
    @Operation(summary="Add WAN replication configuration.", description="Add WAN replication configuration.", tags={"WAN Controller"}, responses={@ApiResponse(responseCode="200", description="WAN replication configuration added successfully.", content={@Content(mediaType="application/json", schema=@Schema(implementation=AddWanConfigResultModel.class), examples={@ExampleObject(name="OK", value="{\n \"addedPublisherIds\": [\"publisher1\", \"publisher2\"],\n \"ignoredPublisherIds\": [\"publisher3\"]\n}")})})})
    ResponseEntity<AddWanConfigResultModel> addWanConfig(@RequestBody @Validated @Parameter(in=ParameterIn.DEFAULT, required=true, description="WAN replication configuration") WanReplicationConfigModel wanReplicationConfigModel) {
        AddWanConfigResultModel result = this.wanService.addWanConfig(wanReplicationConfigModel);
        return ResponseEntity.ok(result);
    }

    @PostMapping(value={"/map-consistency-check/{wanReplicationName}/{publisherId}/{mapName}"})
    @Operation(summary="Initiate WAN consistency check for a specific map.", description="Initiate WAN consistency check for a specific map.", tags={"WAN Controller"}, responses={@ApiResponse(responseCode="200", description="Map consistency check has been initiated successfully.", content={@Content(mediaType="application/json", schema=@Schema(implementation=WanSyncResultModel.class), examples={@ExampleObject(name="OK", description="UUID of the WAN sync operation.", value="{\n \"syncId\": \"e7b3b3b3-4b3b-4b3b-4b3b-4b3b3b3b3b3b\"\n}")})}), @ApiResponse(responseCode="400", description="Wan replication configuration not found.", content={@Content(schema=@Schema(implementation=StatusCodeAndMessage.class), mediaType="application/json", examples={@ExampleObject(name="Bad Request", description="Wan replication configuration not found.", value="{\n \"statusCode\": 400,\n \"message\": \"Wan replication configuration not found.\"\n}")})})})
    ResponseEntity<WanSyncResultModel> mapConsistencyCheck(@PathVariable(value="wanReplicationName") @Parameter(in=ParameterIn.PATH, required=true, description="The name of the wan replication configuration") String wanReplicationName, @PathVariable(value="publisherId") @Parameter(in=ParameterIn.PATH, required=true, description="ID of the WAN replication publisher") String publisherId, @PathVariable(value="mapName") @Parameter(in=ParameterIn.PATH, required=true, description="The name of the map to check") String mapName) {
        UUID syncId = this.wanService.mapConsistencyCheck(wanReplicationName, publisherId, mapName);
        return ResponseEntity.ok(new WanSyncResultModel(syncId.toString()));
    }

    @GetMapping(value={"/progress/{uuid}"})
    @Operation(summary="Retrieve wan sync result.", description="Retrieve wan sync result.", tags={"WAN Controller"}, responses={@ApiResponse(responseCode="200", description="WAN sync progress has been retrieved successfully. Possible states are STARTED, IN_PROGRESS, FINISHED or FAILED.", content={@Content(mediaType="application/json", schema=@Schema(implementation=WanSyncStatusModel.class), examples={@ExampleObject(name="OK", description="WAN sync progress.", value="{\n \"messages\":[{ \"message\": \"message1\"}],\n \"stage\": \"STARTED\",\n \"progress\": 50,\n \"wanReplicationName\": \"wanReplicationName\",\n \"wanPublisherId\": \"wanPublisherId\",\n \"creationTime\": 1234567890\n}")})}), @ApiResponse(responseCode="404", description="Wan replication configuration not found.", content={@Content(schema=@Schema(implementation=StatusCodeAndMessage.class), mediaType="application/json", examples={@ExampleObject(name="Not Found", description="Wan replication configuration not found.", value="{\n \"statusCode\": 404,\n \"message\": \"Wan replication configuration not found.\"\n}")})})})
    ResponseEntity<WanSyncStatusModel> getWanSyncProgress(@Validated @PathVariable(value="uuid") @Parameter(in=ParameterIn.PATH, required=true, description="UUID of the WAN sync operation") UUID uuid) {
        WanSyncStatusModel syncState = this.wanService.getWanSyncState(uuid);
        if (syncState == null) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok(syncState);
    }
}

