/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.rest.controller;

import com.hazelcast.internal.rest.model.MemberDetailModel;
import com.hazelcast.internal.rest.model.SetMemberListResultModel;
import com.hazelcast.internal.rest.model.StatusCodeAndMessage;
import com.hazelcast.internal.rest.service.MemberService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.util.List;
import java.util.UUID;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@RestController
@RequestMapping(value={"/hazelcast/rest/api/v1/cluster/members"})
public class MemberController {
    private final MemberService memberService;

    public MemberController(MemberService memberService) {
        this.memberService = memberService;
    }

    @GetMapping
    @Operation(summary="Retrieve details of Members", description="Endpoint to retrieve details of all Members in the cluster.", tags={"Member Controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=MemberDetailModel.class)), examples={@ExampleObject(name="OK", value="[\n  {\n    \"address\": \"[10.212.134.155]:5701\",\n    \"liteMember\": false,\n    \"localMember\": true,\n    \"uuid\": \"11111111-1111-1111-1111-111111111111\",\n    \"memberVersion\": \"5.4.0\"\n  }\n]")})})})
    List<MemberDetailModel> getMembers() {
        return this.memberService.getMembers();
    }

    @PostMapping
    @Operation(summary="Update the member list of TCP-IP join config", description="Updates the cluster wide configuration for TCP-IP join config dynamically at runtime.", tags={"Member Controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SetMemberListResultModel.class), examples={@ExampleObject(name="OK", value="{\n  \"persistenceEnabled\": true,\n  \"member-list\": [\"10.12.13.1:5701\", \"10.12.13.2:5701\", \"10.12.13.3:5701\"]\n}")})})})
    DeferredResult<SetMemberListResultModel> setMembers(@RequestBody @Parameter(in=ParameterIn.DEFAULT, required=true, description="List of member addresses.") List<String> memberList) {
        return this.memberService.setMemberList(memberList);
    }

    @GetMapping(value={"/self"})
    @Operation(summary="Retrieve details of current/local Member", description="Endpoint to retrieve details of the current/local Member in the cluster.", tags={"Member Controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MemberDetailModel.class), examples={@ExampleObject(name="OK", value="{\n  \"address\": \"[10.212.134.155]:5701\",\n  \"liteMember\": false,\n  \"localMember\": true,\n  \"uuid\": \"11111111-1111-1111-1111-111111111111\",\n  \"memberVersion\": \"5.4.0\"\n}")})})})
    MemberDetailModel getCurrentMember() {
        return this.memberService.getCurrentMember();
    }

    @GetMapping(value={"/{member-uuid}"})
    @Operation(summary="Retrieve details of a Member by UUID", description="Endpoint to retrieve details of a Member based on its UUID in the cluster.", tags={"Member Controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MemberDetailModel.class), examples={@ExampleObject(name="OK", value="{\n  \"address\": \"[10.212.134.155]:5701\",\n  \"liteMember\": false,\n  \"localMember\": true,\n  \"uuid\": \"11111111-1111-1111-1111-111111111111\",\n  \"memberVersion\": \"5.4.0\"\n}")})}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=StatusCodeAndMessage.class), examples={@ExampleObject(name="Bad Request", value="{\n  \"statusCode\": 400,\n  \"message\": \"'member-uuid' should be a valid 'UUID'\"\n}")})}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=StatusCodeAndMessage.class), examples={@ExampleObject(name="Not Found", value="{\n  \"statusCode\": 404,\n  \"message\": \"Member could not be found with the UUID: 11111111-1111-1111-1111-111111111111\"\n}")})})})
    MemberDetailModel getMemberWithUuid(@Parameter(in=ParameterIn.PATH, description="The UUID of the member", required=true) @PathVariable(value="member-uuid") UUID uuid) {
        return this.memberService.getMemberWithUuid(uuid);
    }
}

