/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.rest.controller;

import com.hazelcast.internal.rest.constant.HealthCheck;
import com.hazelcast.internal.rest.model.MemberHealthModel;
import com.hazelcast.internal.rest.service.HealthService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.util.List;
import java.util.Objects;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/hazelcast/rest/api/v1"})
public class HealthController {
    private final HealthService healthService;

    public HealthController(HealthService healthService) {
        this.healthService = healthService;
    }

    @GetMapping(value={"/health"})
    @Operation(summary="Retrieve member health data", description="Endpoint to retrieve the health data of the current member", tags={"Health Controller"}, parameters={@Parameter(name="check", description="Allowed values:\nnodeState - check the node state\nclusterState - check the cluster state\nnumberOfMembers - check the number of members in the cluster\nmemberSafe - check if the partition table on the member is safe")}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MemberHealthModel.class), examples={@ExampleObject(name="Default health checks", value="[\n  {\n    \"nodeState\": \"ACTIVE\",\n    \"clusterState\": \"NO_MIGRATION\",\n    \"numberOfMembers\": 3\n  }\n]")})})})
    MemberHealthModel getHealth(@RequestParam(name="check", required=false) List<HealthCheck> healthCheckList) {
        return this.healthService.memberHealth(Objects.requireNonNullElseGet(healthCheckList, List::of));
    }

    @GetMapping(value={"/ready"})
    @Operation(summary="Retrieve member ready information", description="Endpoint to retrieve the readiness state of the current member", tags={"Health Controller"}, responses={@ApiResponse(responseCode="200", description="Member is ready"), @ApiResponse(responseCode="503", description="Member is not ready")})
    ResponseEntity<Void> getReady() {
        if (!this.healthService.memberReady()) {
            return ResponseEntity.status(HttpStatus.SERVICE_UNAVAILABLE).build();
        }
        return ResponseEntity.ok().build();
    }
}

