/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.rest.controller;

import com.hazelcast.core.HazelcastJsonValue;
import com.hazelcast.internal.rest.model.QueueSizeResultModel;
import com.hazelcast.internal.rest.model.StatusCodeAndMessage;
import com.hazelcast.internal.rest.service.DataService;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@RestController
@Validated
public class DataController {
    private DataService dataService;

    public DataController(DataService dataService) {
        this.dataService = dataService;
    }

    @GetMapping(value={"/hazelcast/rest/api/v1/map/{mapName}/{key}"}, produces={"application/json", "text/plain"})
    @Operation(summary="Get value from map", description="Get value from map", tags={"Data Controller"}, responses={@ApiResponse(responseCode="200", description="The value retrieved successfully. The content can be text or json based on stored type."), @ApiResponse(responseCode="204", description="The value is null or empty"), @ApiResponse(responseCode="404", description="Map with the given name does not exist in the cluster.", content={@Content(mediaType="application/json", schema=@Schema(implementation=StatusCodeAndMessage.class), examples={@ExampleObject(name="Not Found", description="No map with the provided name exists in the cluster.", value="{\n  \"statusCode\": 404,\n  \"message\": \"Map 'mapName' does not exists in the cluster.\"\n}")})})})
    public DeferredResult<ResponseEntity<String>> getMapValue(@Validated @PathVariable(value="mapName") @Parameter(in=ParameterIn.PATH, required=true, description="Name of the map") String mapName, @Validated @PathVariable(value="key") @Parameter(in=ParameterIn.PATH, required=true, description="Key of the value") String key) {
        DeferredResult<ResponseEntity<String>> deferredResult = new DeferredResult<ResponseEntity<String>>();
        this.dataService.getMapValueAsync(mapName, key).whenComplete((o, throwable) -> {
            if (throwable != null) {
                deferredResult.setErrorResult(throwable);
            } else if (o == null) {
                deferredResult.setResult(ResponseEntity.status(HttpStatus.NO_CONTENT).build());
            } else if (o instanceof HazelcastJsonValue) {
                deferredResult.setResult(ResponseEntity.ok().contentType(MediaType.APPLICATION_JSON).body(o.toString()));
            } else if (o instanceof String) {
                deferredResult.setResult(ResponseEntity.ok().contentType(MediaType.TEXT_PLAIN).body(o.toString()));
            } else {
                deferredResult.setErrorResult(new HazelcastSerializationException("Value cannot be serialized over REST"));
            }
        });
        return deferredResult;
    }

    @DeleteMapping(value={"/hazelcast/rest/api/v1/map/{mapName}"})
    @Operation(summary="Clear all values in a map", description="Clear all values in a map", tags={"Data Controller"}, responses={@ApiResponse(responseCode="200", description="Map cleared successfully")})
    public ResponseEntity<Void> clearMap(@Validated @PathVariable(value="mapName") @Parameter(in=ParameterIn.PATH, required=true, description="Name of the map") String mapName) {
        this.dataService.clearMap(mapName);
        return ResponseEntity.ok().build();
    }

    @DeleteMapping(value={"/hazelcast/rest/api/v1/map/{mapName}/{key}"})
    @Operation(summary="Delete value from map", description="Delete value from map", tags={"Data Controller"}, responses={@ApiResponse(responseCode="200", description="Value deleted successfully")})
    public ResponseEntity<Void> deleteMapEntry(@Validated @PathVariable(value="mapName") @Parameter(in=ParameterIn.PATH, required=true, description="Name of the map") String mapName, @Validated @PathVariable(value="key") @Parameter(in=ParameterIn.PATH, required=true, description="Key of the value") String key) {
        this.dataService.deleteEntryFromMap(mapName, key);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/hazelcast/rest/api/v1/map/{mapName}/{key}"}, consumes={"application/json"}, produces={"application/json"})
    @Operation(summary="Add value to map", description="Creates a new key-value pair if the key does not exist. If the key exists, updates the value and returns the old value.", tags={"Data Controller"}, responses={@ApiResponse(responseCode="200", description="Value updated successfully.", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class), examples={@ExampleObject(description="Example json value", value="{\n    \"name\": \"John Doe\",\n    \"age\": 30,\n    \"address\": {\n        \"street\": \"123 Main St\",\n        \"city\": \"New York\"\n    }\n}\n")})}), @ApiResponse(responseCode="201", description="Key-value pair created successfully."), @ApiResponse(responseCode="400", description="Invalid JSON object."), @ApiResponse(responseCode="500", description="Value cannot be serialized over REST.")})
    public DeferredResult<ResponseEntity<String>> mapPutAsJson(@Validated @PathVariable(value="mapName") @Parameter(in=ParameterIn.PATH, required=true, description="Name of the map") String mapName, @Validated @PathVariable(value="key") @Parameter(in=ParameterIn.PATH, required=true, description="Key of the value") String key, @Validated @RequestBody @Parameter(in=ParameterIn.DEFAULT, required=true, description="Value to be added. The content type must be either `application/json` or `text/plain`.") String value) {
        DeferredResult<ResponseEntity<String>> deferredResult = new DeferredResult<ResponseEntity<String>>();
        HazelcastJsonValue jsonValue = new HazelcastJsonValue(value);
        this.dataService.putMapValueAsync(mapName, key, jsonValue).whenComplete((o, throwable) -> {
            if (throwable == null) {
                if (o == null) {
                    deferredResult.setResult(ResponseEntity.status(HttpStatus.CREATED).build());
                } else {
                    deferredResult.setResult(ResponseEntity.ok(o.toString()));
                }
            } else {
                deferredResult.setErrorResult(throwable);
            }
        });
        return deferredResult;
    }

    @PostMapping(value={"/hazelcast/rest/api/v1/map/{mapName}/{key}"}, consumes={"text/plain"}, produces={"text/plain"})
    @Operation(summary="Add value to map", description="Creates a new key-value pair if the key does not exist. If the key exists, updates the value and returns the old value.", tags={"Data Controller"}, responses={@ApiResponse(responseCode="200", description="Value updated successfully.", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class), examples={@ExampleObject(description="Example text value", value="John Doe")})}), @ApiResponse(responseCode="201", description="Key-value pair created successfully.")})
    public DeferredResult<ResponseEntity<String>> mapPutAsString(@Validated @PathVariable(value="mapName") @Parameter(in=ParameterIn.PATH, required=true, description="Name of the map") String mapName, @Validated @PathVariable(value="key") @Parameter(in=ParameterIn.PATH, required=true, description="Key of the value") String key, @Validated @RequestBody @Parameter(in=ParameterIn.DEFAULT, required=true, description="Value to be added. The content type must be either `application/json` or `text/plain`.") String value) {
        DeferredResult<ResponseEntity<String>> deferredResult = new DeferredResult<ResponseEntity<String>>();
        this.dataService.putMapValueAsync(mapName, key, value).whenComplete((o, throwable) -> {
            if (throwable == null) {
                if (o == null) {
                    deferredResult.setResult(ResponseEntity.status(HttpStatus.CREATED).build());
                } else {
                    deferredResult.setResult(ResponseEntity.ok(o.toString()));
                }
            } else {
                deferredResult.setErrorResult(throwable);
            }
        });
        return deferredResult;
    }

    @DeleteMapping(value={"/hazelcast/rest/api/v1/queue/{queueName}"}, produces={"application/json", "text/plain"})
    @Operation(summary="Pool an item from the queue", description="Retrieves and removes the head of this queue in given timeout. The default timeout value is 0 second.", tags={"Data Controller"}, responses={@ApiResponse(responseCode="200", description="The value retrieved successfully. The content can be text or json based on stored type."), @ApiResponse(responseCode="204", description="Queue is empty or request timed out")})
    public ResponseEntity<String> poolQueueItem(@Validated @PathVariable(value="queueName") @Parameter(in=ParameterIn.PATH, required=true, description="Name of the queue") String queueName, @Validated @RequestParam(value="timeoutSec", required=false) @Parameter(in=ParameterIn.QUERY, description="Timeout in seconds. Default is 0 second. It means how long to wait before giving up to pool the item.") Integer timeoutSec) {
        Object o;
        if (timeoutSec == null) {
            timeoutSec = 0;
        }
        if ((o = this.dataService.pollFromQueue(queueName, timeoutSec)) == null) {
            return ResponseEntity.status(HttpStatus.NO_CONTENT).build();
        }
        if (o instanceof HazelcastJsonValue) {
            return ResponseEntity.ok().contentType(MediaType.APPLICATION_JSON).body(o.toString());
        }
        if (o instanceof String) {
            return ResponseEntity.ok().contentType(MediaType.TEXT_PLAIN).body(o.toString());
        }
        throw new HazelcastSerializationException("Value cannot be serialized over REST");
    }

    @GetMapping(value={"/hazelcast/rest/api/v1/queue/{queueName}/size"})
    @Operation(summary="Get size of the queue", description="Get size of the queue", tags={"Data Controller"}, responses={@ApiResponse(responseCode="200", description="Queue size retrieved successfully", content={@Content(mediaType="application/json", schema=@Schema(implementation=QueueSizeResultModel.class))}), @ApiResponse(responseCode="404", description="Queue with the given name does not exist in the cluster.", content={@Content(mediaType="application/json", schema=@Schema(implementation=StatusCodeAndMessage.class), examples={@ExampleObject(name="Not Found", description="No queue with the provided name exists in the cluster.", value="{\n  \"statusCode\": 404,\n  \"message\": \"Queue 'queueName' does not exists in the cluster.\"\n}")})})})
    public ResponseEntity<QueueSizeResultModel> getQueueSize(@Validated @PathVariable(value="queueName") @Parameter(in=ParameterIn.PATH, required=true, description="Name of the queue") String queueName) {
        return ResponseEntity.ok().body(new QueueSizeResultModel(this.dataService.getQueueSize(queueName)));
    }

    @PostMapping(value={"/hazelcast/rest/api/v1/queue/{queueName}"}, consumes={"application/json"})
    @Operation(summary="Add item to the queue", description="Add item to the queue", tags={"Data Controller"}, responses={@ApiResponse(responseCode="200", description="Item added successfully", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class), examples={@ExampleObject(description="Example json value", value="{\n    \"name\": \"John Doe\",\n    age: 30,\n    \"address\": {\n        \"street\": \"123 Main St\",\n        \"city\": \"New York\"\n    }\n}\n")})}), @ApiResponse(responseCode="500", description="Queue is full")})
    public ResponseEntity<Void> offerQueueItemAsJson(@Validated @PathVariable(value="queueName") @Parameter(in=ParameterIn.PATH, required=true, description="Name of the queue") String queueName, @Validated @RequestBody @Parameter(in=ParameterIn.DEFAULT, required=true, description="Value to be added. The content type must be either `application/json` or `text/plain`.") String value, @Validated @RequestParam(value="timeoutSec", required=false) @Parameter(in=ParameterIn.QUERY, required=false, description="Timeout in seconds. Default is 0 second. It means how long to wait before giving up to add the item. -1 for infinite timeout.") Integer timeoutSec) {
        HazelcastJsonValue jsonValue;
        if (timeoutSec == null) {
            timeoutSec = 0;
        }
        if (this.dataService.offerQueueItem(queueName, jsonValue = new HazelcastJsonValue(value), timeoutSec)) {
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).build();
    }

    @PostMapping(value={"/hazelcast/rest/api/v1/queue/{queueName}"}, consumes={"text/plain"})
    @Operation(summary="Add item to the queue", description="Add item to the queue", tags={"Data Controller"}, responses={@ApiResponse(responseCode="200", description="Item added successfully"), @ApiResponse(responseCode="500", description="Queue is full")})
    public ResponseEntity<Void> offerQueueItemAsString(@Validated @PathVariable(value="queueName") @Parameter(in=ParameterIn.PATH, required=true, description="Name of the queue") String queueName, @Validated @RequestBody @Parameter(in=ParameterIn.DEFAULT, required=true, description="Value to be added. The content type must be either `application/json` or `text/plain`.") String item, @Validated @RequestParam(value="timeoutSec", required=false) @Parameter(in=ParameterIn.QUERY, description="Timeout in seconds. Default is 0 second. It means how long to wait before giving up to add the item. -1 for infinite timeout.") Integer timeoutSec) {
        if (timeoutSec == null) {
            timeoutSec = 0;
        }
        if (this.dataService.offerQueueItem(queueName, item, timeoutSec)) {
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).build();
    }
}

