/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.rest.controller;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.internal.rest.model.ClusterStateModel;
import com.hazelcast.internal.rest.model.ClusterStatusModel;
import com.hazelcast.internal.rest.model.ClusterVersionModel;
import com.hazelcast.internal.rest.model.ConfigActionResultModel;
import com.hazelcast.internal.rest.model.LicenseInfoModel;
import com.hazelcast.internal.rest.model.LicenseKeyModel;
import com.hazelcast.internal.rest.model.LogLevelModel;
import com.hazelcast.internal.rest.model.MemberConfigResponseModel;
import com.hazelcast.internal.rest.model.SetLicenseInfoResultModel;
import com.hazelcast.internal.rest.model.StatusCodeAndMessage;
import com.hazelcast.internal.rest.service.ClusterService;
import com.hazelcast.version.Version;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.validation.Valid;
import java.util.Collection;
import java.util.UUID;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@RestController
@RequestMapping(value={"/hazelcast/rest/api/v1/cluster"})
@Validated
public class ClusterController {
    private final ClusterService clusterService;

    public ClusterController(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    @GetMapping
    @Operation(summary="Retrieve cluster status", tags={"Cluster Controller"}, description="Endpoint to retrieve the cluster status.", responses={@ApiResponse(responseCode="200", description="Cluster status has been retrieved successfully.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ClusterStatusModel.class), examples={@ExampleObject(name="OK", description="Cluster status has been retrieved successfully.", value="{\n  \"members\": [\n    {\n      \"address\": \"[192.168.0.24]:5701\",\n      \"liteMember\": false,\n      \"localMember\": true,\n      \"uuid\": \"11111111-1111-1111-1111-111111111111\",\n      \"memberVersion\": \"5.4.0\"\n    }\n  ],\n  \"clientCount\": 0,\n  \"allConnectionCount\": 0,\n  \"state\": \"ACTIVE\",\n  \"version\": \"5.4\"\n}")})})})
    ClusterStatusModel getClusterStatus() {
        return this.clusterService.getClusterStatus();
    }

    @GetMapping(value={"/state"})
    @Operation(summary="Retrieve the cluster state", tags={"Cluster Controller"}, description="Endpoint to retrieve the cluster state.", responses={@ApiResponse(responseCode="200", description="Cluster state has been retrieved successfully.", content={@Content(mediaType="application/json", examples={@ExampleObject(name="OK", description="Cluster state has been retrieved successfully.", value="{\n  \"state\": \"ACTIVE\"\n}")})})})
    ClusterStateModel getClusterState() {
        return this.clusterService.getClusterState();
    }

    @GetMapping(value={"/version"})
    @Operation(summary="Retrieve the cluster version", tags={"Cluster Controller"}, description="Endpoint to retrieve the cluster version.", responses={@ApiResponse(responseCode="200", description="Cluster version has been retrieved successfully.", content={@Content(mediaType="application/json", examples={@ExampleObject(name="OK", description="Cluster version has been retrieved successfully.", value="{\n  \"major\": 5,\n  \"minor\": 4\n}")})})})
    ClusterVersionModel getClusterVersion() {
        return this.clusterService.getClusterVersion();
    }

    @PostMapping(value={"/state"})
    @Operation(summary="Change the cluster state", description="Endpoint to change the cluster state.", tags={"Cluster Controller"}, responses={@ApiResponse(responseCode="200", description="Cluster state is updated successfully."), @ApiResponse(responseCode="400", description="Given cluster state is invalid.")})
    ResponseEntity<StatusCodeAndMessage> changeClusterState(@RequestBody @Valid ClusterStateModel requestBody) {
        ClusterState state = requestBody.state();
        if (!this.clusterService.isValid(state)) {
            return ResponseEntity.badRequest().body(new StatusCodeAndMessage(HttpStatus.BAD_REQUEST.value(), "Cluster state cannot be set to " + String.valueOf(state) + "."));
        }
        this.clusterService.changeClusterState(state);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/version"})
    @Operation(summary="Change the cluster version", description="Endpoint to change the cluster version.", tags={"Cluster Controller"}, responses={@ApiResponse(responseCode="200", description="Cluster version is updated successfully."), @ApiResponse(responseCode="400", description="Given cluster version is invalid.")})
    ResponseEntity<Void> changeClusterVersion(@RequestBody @Valid ClusterVersionModel requestBody) {
        Version version = Version.of((int)requestBody.major(), (int)requestBody.minor());
        this.clusterService.changeClusterVersion(version);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/license"})
    @Operation(summary="Retrieve the license", tags={"Cluster Controller"}, description="Endpoint to retrieve the license.", responses={@ApiResponse(responseCode="200", description="License has been retrieved successfully.", content={@Content(mediaType="application/json", schema=@Schema(implementation=LicenseInfoModel.class), examples={@ExampleObject(name="OK", description="License has been retrieved successfully.", value="{\n  \"expirationTimeMs\": 4097606399999,\n  \"maxNodeCountAllowed\": 99,\n  \"allowedTieredStoreSize\": 0,\n  \"allowedNativeMemorySize\": 100,\n  \"allowedTpcCores\": 0,\n  \"keyHash\": \"9ZAG+TXHy0PrAEakoikYri8WNTFeaJYMeLvsGavEp48=\",\n  \"features\": [\n    \"Management Center\",\n    \"Clustered JMX\",\n    \"Clustered REST\",\n    \"Security\",\n    \"WAN Replication\",\n    \"High Density Memory\",\n    \"Persistence\",\n    \"Rolling Upgrade\",\n    \"Cluster Client Filtering\",\n    \"CP Subsystem Persistence\"\n  ]\n}")})})})
    LicenseInfoModel getClusterLicense() {
        return this.clusterService.getLicenseInfo();
    }

    @PostMapping(value={"/license"})
    @Operation(summary="Update the license key", tags={"Cluster Controller"}, description="Endpoint to update the license key.", responses={@ApiResponse(responseCode="200", description="License has been updated successfully.", content={@Content(mediaType="application/json", schema=@Schema(implementation=SetLicenseInfoResultModel.class), examples={@ExampleObject(name="OK", description="License has been updated successfully.", value="{\n  \"persistenceEnabled\": true,\n  \"message\": \"License updated at run time.\"\n}")})}), @ApiResponse(responseCode="400", description="Provided license is invalid.", content={@Content(mediaType="application/json", schema=@Schema(implementation=StatusCodeAndMessage.class), examples={@ExampleObject(name="Bad Request", value="{\n  \"statusCode\": 400,\n  \"message\": \"Invalid license key!\"\n}")})})})
    DeferredResult<SetLicenseInfoResultModel> updateLicense(@RequestBody LicenseKeyModel requestBody) {
        return this.clusterService.setLicenseInfo(requestBody.licenseKey());
    }

    @GetMapping(value={"/log-level"})
    @Operation(summary="Retrieve the log level", tags={"Cluster Controller"}, description="Endpoint to retrieve the log level.", responses={@ApiResponse(responseCode="200", description="Log level has been retrieved successfully.", content={@Content(mediaType="application/json", schema=@Schema(implementation=LogLevelModel.class), examples={@ExampleObject(name="OK", description="Log level has been retrieved successfully.", value="{\n  \"logLevel\": \"INFO\"\n}")})})})
    LogLevelModel getLogLevel() {
        return this.clusterService.getLogLevel();
    }

    @PostMapping(value={"/log-level"})
    @Operation(summary="Set the log level", description="Endpoint to set the log level. Possible values are OFF, SEVERE, WARNING, INFO, CONFIG, FINE, FINER, FINEST. Note that log-level actions are localized and, affects only the single member where the REST server is running, not the entire cluster.", tags={"Cluster Controller"}, responses={@ApiResponse(responseCode="200", description="Log level has been set successfully."), @ApiResponse(responseCode="400", description="Invalid log level, known levels are: OFF, SEVERE, WARNING, INFO, CONFIG, FINE, FINER, FINEST")})
    ResponseEntity<Void> setLogLevel(@RequestBody LogLevelModel requestBody) {
        this.clusterService.setLogLevel(requestBody.logLevel());
        return ResponseEntity.ok().build();
    }

    @DeleteMapping(value={"/log-level"})
    @Operation(summary="Reset the log level", description="Endpoint to reset the levels of all the loggers known to the logging service back to the default reconfigured values. Basically, reverts changes made by previous setLevel(Level) calls or POST requests to /hazelcast/rest/api/v1/cluster/log-level, if any. Note that log-level actions are localized and, affects only the single member where the REST server is running, not the entire cluster.", tags={"Cluster Controller"}, responses={@ApiResponse(responseCode="200", description="Log level has been reset successfully.")})
    ResponseEntity<Void> resetLogLevel() {
        this.clusterService.resetLogLevel();
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/config"})
    @Operation(summary="Retrieve the server configuration from file (XML/YAML).", description="Endpoint to retrieve the server configuration as loaded from XML or YAML files.\n\nNotes:\n- If the server was started without a configuration file (XML/YAML),\n  the configuration value will always be an empty string.\n- Runtime configuration changes (via programmatic setup, MC, REST API etc.) are\n  **not included** in the response.\n- If dynamic configuration persistence is enabled, then any runtime changes made\n  after member startup will be written back to the original configuration file,\n  and therefore, will appear in the response. Runtime changes made before member\n  startup are not persisted.\n", tags={"Cluster Controller"}, responses={@ApiResponse(responseCode="200", description="Configuration has been retrieved successfully.", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=MemberConfigResponseModel.class)), examples={@ExampleObject(name="OK", description="Example response showing member UUIDs mapped to configuration\nfile contents (empty string if no file was used).\n", value="[\n  {\n    \"memberId\": \"11111111-1111-1111-1111-111111111111\",\n    \"configuration\": \"<hazelcast>...</hazelcast>\"\n  },\n  {\n    \"memberId\": \"22222222-2222-2222-2222-222222222222\",\n    \"configuration\": \"\"\n  }\n]")})})})
    DeferredResult<ResponseEntity<Collection<MemberConfigResponseModel>>> getMemberConfigs() {
        return this.clusterService.getMemberConfigs();
    }

    @GetMapping(value={"/config/{member-uuid}"})
    @Operation(summary="Retrieve the server configuration for a specific member from file (XML/YAML).", description="Endpoint to retrieve the server configuration for the given member UUID as loaded from XML or YAML files.\n\nNotes:\n- If the server was started without a configuration file (XML/YAML),\n  the configuration value will always be an empty string.\n- Runtime configuration changes (via programmatic setup, MC, REST API etc.) are\n  **not included** in the response.\n- If dynamic configuration persistence is enabled, then any runtime changes made\n  after member startup will be written back to the original configuration file,\n  and therefore, will appear in the response. Runtime changes made before member\n  startup are not persisted.\n", tags={"Cluster Controller"}, responses={@ApiResponse(responseCode="200", description="Configuration has been retrieved successfully.", content={@Content(mediaType="application/json", schema=@Schema(implementation=MemberConfigResponseModel.class), examples={@ExampleObject(name="OK", description="Example response showing configuration for a single member UUID\n(empty string if no file was used).\n", value="{\n    \"memberId\": \"11111111-1111-1111-1111-111111111111\",\n    \"configuration\": \"\"\n}")})}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=StatusCodeAndMessage.class), examples={@ExampleObject(name="Not Found", description="No member with the UUID exists in the cluster.", value="{\n  \"statusCode\": 404,\n  \"message\": \"No member with UUID exists in cluster.\"\n}")})})})
    DeferredResult<ResponseEntity<MemberConfigResponseModel>> getMemberConfigByUuid(@Parameter(in=ParameterIn.PATH, description="The UUID of the member", required=true) @PathVariable(value="member-uuid") UUID uuid) {
        return this.clusterService.getMemberConfigByUuid(uuid);
    }

    @PostMapping(value={"/config/reload"})
    @Operation(summary="Reload server configuration from declarative config", description="Updates the configuration with the declarative configuration. Updating means dynamically changing all the differences dynamically changeable.", tags={"Config Controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ConfigActionResultModel.class), examples={@ExampleObject(name="OK", value="{\n  \"addedConfigs\": [\n                      {\n                          \"sectionName\": \"cp-subsystem\",\n                          \"configName\": \"enabled\"\n                      },\n                      {\n                          \"sectionName\": \"network\",\n                          \"configName\": \"public-address\"\n                      }\n                  ],\n  \"ignoredConfigs\": [\n                      {\n                          \"sectionName\": \"network\",\n                          \"configName\": \"join\"\n                      },\n                      {\n                          \"sectionName\": \"network\",\n                          \"configName\": \"outbound-ports\"\n                      }\n                     ]\n }")})}), @ApiResponse(responseCode="500", description="Invalid license exception or configuration validation exception or configuration parsing exception.", content={@Content(mediaType="application/json", schema=@Schema(implementation=StatusCodeAndMessage.class), examples={@ExampleObject(name="Internal Server Error", value="{\n  \"statusCode\": 500,\n  \"message\": \"The feature Dynamic Configuration is not enabled for your license.\"\n}")})})})
    ConfigActionResultModel reload() {
        return this.clusterService.reload();
    }

    @PostMapping(value={"/config/update"})
    @Operation(summary="Update the configuration with the provided string format in either YAML or XML.", description="Endpoint to update the configuration with the provided string format in either YAML or XML. Updating means dynamically changing all the differences dynamically changeable.", tags={"Cluster Controller"}, responses={@ApiResponse(responseCode="200", description="Configuration update successfully finished.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ConfigActionResultModel.class), examples={@ExampleObject(name="OK", description="Configuration update successfully finished.", value="{\n  \"addedConfigs\": [\n    {\n      \"sectionName\": \"map\",\n      \"configName\": \"my-map\"\n    }\n  ],\n  \"ignoredConfigs\": [\n    {\n      \"sectionName\": \"local-device\",\n      \"configName\": \"default-tiered-store-device\"\n    }\n  ]\n}")})}), @ApiResponse(responseCode="400", description="Invalid configuration exception or configuration parsing exception.", content={@Content(mediaType="application/json", schema=@Schema(implementation=StatusCodeAndMessage.class), examples={@ExampleObject(name="Bad Request", value="{\n  \"statusCode\": 400,\n  \"message\": \"The resource is neither valid XML nor valid YAML.\"\n}")})}), @ApiResponse(responseCode="500", description="Invalid license exception.", content={@Content(mediaType="application/json", schema=@Schema(implementation=StatusCodeAndMessage.class), examples={@ExampleObject(name="Internal Server Error", value="{\n  \"statusCode\": 500,\n  \"message\": \"Invalid License Key!\"\n}")})})})
    ResponseEntity<ConfigActionResultModel> updateConfig(@RequestBody @Valid String requestBody) {
        return ResponseEntity.ok(this.clusterService.updateConfig(requestBody));
    }
}

