/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.rest.access;

import com.hazelcast.rest.access.RestAuthorizationContext;
import java.net.InetAddress;

public class SimpleAuthorizationContext
implements RestAuthorizationContext {
    private final InetAddress remoteAddress;
    private final String resourcePath;
    private final String methodName;

    private SimpleAuthorizationContext(Builder builder) {
        this.remoteAddress = builder.remoteAddress;
        this.resourcePath = builder.resourcePath;
        this.methodName = builder.methodName;
    }

    public InetAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public String getResourcePath() {
        return this.resourcePath;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private InetAddress remoteAddress;
        private String resourcePath;
        private String methodName;

        private Builder() {
        }

        public Builder withRemoteAddress(InetAddress remoteAddress) {
            this.remoteAddress = remoteAddress;
            return this;
        }

        public Builder withResourcePath(String resourcePath) {
            this.resourcePath = resourcePath;
            return this;
        }

        public Builder withMethodName(String methodName) {
            this.methodName = methodName;
            return this;
        }

        public SimpleAuthorizationContext build() {
            return new SimpleAuthorizationContext(this);
        }
    }
}

