/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.rest.access;

import com.hazelcast.access.AccessControlService;
import com.hazelcast.access.AuthenticationContext;
import com.hazelcast.access.AuthorizationContext;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.rest.access.RestAuthenticationContext;
import com.hazelcast.rest.access.RestAuthorizationContext;
import com.hazelcast.security.ClusterRolePrincipal;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.HazelcastPrincipal;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.security.SimpleTokenCredentials;
import com.hazelcast.security.UsernamePasswordCredentials;
import java.security.Principal;
import java.util.Arrays;
import java.util.Objects;
import javax.security.auth.Subject;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class DefaultAccessControlService
implements AccessControlService {
    public static final String ROLE_READER = "reader";
    public static final String ROLE_WRITER = "writer";
    public static final String ROLE_ADMIN = "admin";
    private final SecurityContext securityContext;
    private final String authenticationRealm;

    public DefaultAccessControlService(SecurityContext securityContext, String authenticationRealm) {
        this.securityContext = Objects.requireNonNull(securityContext);
        this.authenticationRealm = Objects.requireNonNull(authenticationRealm, "The authenticationRealm has to be provided");
    }

    public String[] authenticate(AuthenticationContext ctx) throws LoginException {
        UsernamePasswordCredentials creds;
        if (!(ctx instanceof RestAuthenticationContext)) {
            throw new LoginException("Unsupported AuthenticationContext used");
        }
        RestAuthenticationContext restCtx = (RestAuthenticationContext)ctx;
        if (restCtx.getUsername() != null) {
            creds = new UsernamePasswordCredentials(restCtx.getUsername(), restCtx.getPassword());
        } else if (restCtx.getToken() != null) {
            creds = new SimpleTokenCredentials(restCtx.getToken());
        } else {
            throw new LoginException("Neither username/password nor token provided.");
        }
        Configuration configuration = this.securityContext.createLoginConfigurationForRealm(this.authenticationRealm);
        LoginContext lc = this.securityContext.createLoginContext(configuration, null, (Credentials)creds, null);
        lc.login();
        return this.getPrincipalNames(lc.getSubject(), ClusterRolePrincipal.class);
    }

    public boolean isAccessGranted(AuthorizationContext ctx, String ... assignedRoles) {
        if (!(ctx instanceof RestAuthorizationContext)) {
            throw new IllegalArgumentException("RestAuthorizationContext instance was expected in isAccessGranted() call, but the instance is: " + String.valueOf(ctx));
        }
        RestAuthorizationContext restCtx = (RestAuthorizationContext)ctx;
        return this.isResourceAccessGranted(restCtx.getResourcePath(), restCtx.getMethodName(), assignedRoles);
    }

    private boolean isResourceAccessGranted(String resourcePath, String methodName, String ... assignedRoles) {
        boolean isReader = this.isRoleAssigned(ROLE_READER, assignedRoles);
        boolean isWriter = this.isRoleAssigned(ROLE_WRITER, assignedRoles);
        boolean isAdmin = this.isRoleAssigned(ROLE_ADMIN, assignedRoles);
        if (Objects.equals(methodName, "GET")) {
            return isReader || isWriter || isAdmin;
        }
        return isWriter || isAdmin;
    }

    private boolean isRoleAssigned(String role, String ... assignedRoles) {
        return Arrays.stream(assignedRoles).map(StringUtil::lowerCaseInternal).anyMatch(role::equals);
    }

    private String[] getPrincipalNames(Subject subject, Class<? extends HazelcastPrincipal> principalClass) {
        return (String[])subject.getPrincipals(principalClass).stream().map(Principal::getName).toArray(String[]::new);
    }
}

