/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.mustache;

import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import java.io.StringReader;
import java.io.Writer;
import java.security.AccessController;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.text.SizeLimitingStringWriter;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.MemorySizeValue;
import org.elasticsearch.script.GeneralScriptException;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptEngine;
import org.elasticsearch.script.ScriptException;
import org.elasticsearch.script.TemplateScript;
import org.elasticsearch.script.mustache.CustomMustacheFactory;

public final class MustacheScriptEngine
implements ScriptEngine {
    private static final Logger logger = LogManager.getLogger(MustacheScriptEngine.class);
    public static final String NAME = "mustache";
    public static final Setting<ByteSizeValue> MUSTACHE_RESULT_SIZE_LIMIT = new Setting<ByteSizeValue>("mustache.max_output_size_bytes", s -> "1mb", s -> MemorySizeValue.parseBytesSizeValueOrHeapRatio(s, "mustache.max_output_size_bytes"), Setting.Property.NodeScope);
    private final int sizeLimit;

    public MustacheScriptEngine(Settings settings) {
        this.sizeLimit = (int)MUSTACHE_RESULT_SIZE_LIMIT.get(settings).getBytes();
    }

    public <T> T compile(String templateName, String templateSource, ScriptContext<T> context, Map<String, String> options) {
        if (!context.instanceClazz.equals(TemplateScript.class)) {
            throw new IllegalArgumentException("mustache engine does not know how to handle context [" + context.name + "]");
        }
        CustomMustacheFactory factory = this.createMustacheFactory(options);
        StringReader reader = new StringReader(templateSource);
        try {
            Mustache template = factory.compile(reader, "query-template");
            TemplateScript.Factory compiled = params -> new MustacheExecutableScript(template, params);
            return (T)context.factoryClazz.cast(compiled);
        }
        catch (MustacheException ex) {
            throw new ScriptException(ex.getMessage(), (Throwable)ex, Collections.emptyList(), templateSource, NAME);
        }
    }

    @Override
    public Set<ScriptContext<?>> getSupportedContexts() {
        return org.elasticsearch.core.Set.of(TemplateScript.CONTEXT, TemplateScript.INGEST_CONTEXT);
    }

    private CustomMustacheFactory createMustacheFactory(Map<String, String> options) {
        if (options == null || options.isEmpty() || !options.containsKey("content_type")) {
            return new CustomMustacheFactory();
        }
        return new CustomMustacheFactory(options.get("content_type"));
    }

    @Override
    public String getType() {
        return NAME;
    }

    private class MustacheExecutableScript
    extends TemplateScript {
        private Mustache template;
        private Map<String, Object> params;

        MustacheExecutableScript(Mustache template, Map<String, Object> params) {
            super(params);
            this.template = template;
            this.params = params;
        }

        @Override
        public String execute() {
            SizeLimitingStringWriter writer = new SizeLimitingStringWriter(MustacheScriptEngine.this.sizeLimit);
            try {
                SpecialPermission.check();
                AccessController.doPrivileged(() -> {
                    this.template.execute((Writer)writer, this.params);
                    return null;
                });
            }
            catch (Exception e) {
                if (ExceptionsHelper.unwrap(e, SizeLimitingStringWriter.SizeLimitExceededException.class) != null) {
                    throw new ElasticsearchParseException("Mustache script result size limit exceeded", (Throwable)e, new Object[0]);
                }
                logger.error(() -> new ParameterizedMessage("Error running {}", (Object)this.template), (Throwable)e);
                throw new GeneralScriptException("Error running " + this.template, e);
            }
            return writer.toString();
        }
    }
}

