/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.XContentType;

public class SourceToParse {
    private final BytesReference source;
    private final String index;
    private final String type;
    private final String id;
    @Nullable
    private final String routing;
    private final XContentType xContentType;
    private final Map<String, String> dynamicTemplates;

    public SourceToParse(String index, String type, String id, BytesReference source, XContentType xContentType, @Nullable String routing, Map<String, String> dynamicTemplates) {
        this.index = Objects.requireNonNull(index);
        this.type = Objects.requireNonNull(type);
        this.id = Objects.requireNonNull(id);
        this.source = new BytesArray(Objects.requireNonNull(source).toBytesRef());
        this.xContentType = Objects.requireNonNull(xContentType);
        this.routing = routing;
        this.dynamicTemplates = Objects.requireNonNull(dynamicTemplates);
    }

    public SourceToParse(String index, String type, String id, BytesReference source, XContentType xContentType) {
        this(index, type, id, source, xContentType, null, Collections.emptyMap());
    }

    public BytesReference source() {
        return this.source;
    }

    public String index() {
        return this.index;
    }

    public String type() {
        return this.type;
    }

    public String id() {
        return this.id;
    }

    @Nullable
    public String routing() {
        return this.routing;
    }

    public Map<String, String> dynamicTemplates() {
        return this.dynamicTemplates;
    }

    public XContentType getXContentType() {
        return this.xContentType;
    }

    public static enum Origin {
        PRIMARY,
        REPLICA;

    }
}

