/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.ordinals;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongValues;

class SingletonGlobalOrdinalMapping
extends SortedDocValues {
    private final SortedDocValues values;
    private final OrdinalMap ordinalMap;
    private final LongValues mapping;
    private final TermsEnum[] lookups;

    static SortedSetDocValues singletonIfPossible(OrdinalMap ordinalMap, SortedSetDocValues values, TermsEnum[] lookups, int segmentIndex) {
        if (ordinalMap.getValueCount() > Integer.MAX_VALUE) {
            return null;
        }
        SortedDocValues singleton = DocValues.unwrapSingleton(values);
        if (singleton == null) {
            return null;
        }
        return DocValues.singleton(new SingletonGlobalOrdinalMapping(ordinalMap, singleton, lookups, segmentIndex));
    }

    private SingletonGlobalOrdinalMapping(OrdinalMap ordinalMap, SortedDocValues values, TermsEnum[] lookups, int segmentIndex) {
        this.values = values;
        this.lookups = lookups;
        this.ordinalMap = ordinalMap;
        this.mapping = ordinalMap.getGlobalOrds(segmentIndex);
    }

    @Override
    public int getValueCount() {
        return (int)this.ordinalMap.getValueCount();
    }

    @Override
    public int ordValue() throws IOException {
        return (int)this.mapping.get(this.values.ordValue());
    }

    @Override
    public boolean advanceExact(int target) throws IOException {
        return this.values.advanceExact(target);
    }

    @Override
    public BytesRef lookupOrd(int globalOrd) throws IOException {
        long segmentOrd = this.ordinalMap.getFirstSegmentOrd(globalOrd);
        int readerIndex = this.ordinalMap.getFirstSegmentNumber(globalOrd);
        this.lookups[readerIndex].seekExact(segmentOrd);
        return this.lookups[readerIndex].term();
    }

    @Override
    public int docID() {
        return this.values.docID();
    }

    @Override
    public int nextDoc() throws IOException {
        return this.values.nextDoc();
    }

    @Override
    public int advance(int target) throws IOException {
        return this.values.advance(target);
    }

    @Override
    public long cost() {
        return this.values.cost();
    }
}

