/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import com.hazelcast.shaded.com.fasterxml.jackson.core.io.JsonStringEncoder;
import java.nio.charset.Charset;
import java.util.StringJoiner;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.ExtendedThrowablePatternConverter;
import org.apache.logging.log4j.core.pattern.ThrowablePatternConverter;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="JsonThrowablePatternConverter", category="Converter")
@ConverterKeys(value={"exceptionAsJson"})
public final class JsonThrowablePatternConverter
extends ThrowablePatternConverter {
    private final ExtendedThrowablePatternConverter throwablePatternConverter;

    private JsonThrowablePatternConverter(Configuration config, String[] options) {
        super("JsonThrowablePatternConverter", "throwable", options, config);
        this.throwablePatternConverter = ExtendedThrowablePatternConverter.newInstance((Configuration)config, (String[])options);
    }

    public static JsonThrowablePatternConverter newInstance(Configuration config, String[] options) {
        return new JsonThrowablePatternConverter(config, options);
    }

    public void format(LogEvent event, StringBuilder toAppendTo) {
        String consoleStacktrace = this.formatStacktrace(event);
        if (Strings.isNotEmpty((CharSequence)consoleStacktrace)) {
            String jsonStacktrace = this.formatJson(consoleStacktrace);
            toAppendTo.append(", ");
            toAppendTo.append(jsonStacktrace);
        }
    }

    private String formatStacktrace(LogEvent event) {
        StringBuilder stringBuilder = new StringBuilder();
        this.throwablePatternConverter.format(event, stringBuilder);
        return stringBuilder.toString();
    }

    private String formatJson(String consoleStacktrace) {
        String lineSeparator = this.options.getSeparator() + "\t|" + this.options.getSeparator();
        String[] split = consoleStacktrace.split(lineSeparator);
        StringJoiner stringJoiner = new StringJoiner(",\n", "\n\"stacktrace\": [", "]");
        for (String line : split) {
            stringJoiner.add(this.wrapAsJson(line));
        }
        return stringJoiner.toString();
    }

    private String wrapAsJson(String line) {
        byte[] bytes = JsonStringEncoder.getInstance().quoteAsUTF8(line);
        return "\"" + new String(bytes, Charset.defaultCharset()) + "\"";
    }

    public boolean handlesThrowable() {
        return true;
    }
}

