/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transform.transforms;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public class TransformIndexerStats {
    public static final String NAME = "transform_indexer_stats";
    static ParseField EXPONENTIAL_AVG_CHECKPOINT_DURATION_MS = new ParseField("exponential_avg_checkpoint_duration_ms", new String[0]);
    static ParseField EXPONENTIAL_AVG_DOCUMENTS_INDEXED = new ParseField("exponential_avg_documents_indexed", new String[0]);
    static ParseField EXPONENTIAL_AVG_DOCUMENTS_PROCESSED = new ParseField("exponential_avg_documents_processed", new String[0]);
    static ParseField PAGES_PROCESSED = new ParseField("pages_processed", new String[0]);
    static ParseField DOCUMENTS_PROCESSED = new ParseField("documents_processed", new String[0]);
    static ParseField DOCUMENTS_INDEXED = new ParseField("documents_indexed", new String[0]);
    static ParseField DOCUMENTS_DELETED = new ParseField("documents_deleted", new String[0]);
    static ParseField TRIGGER_COUNT = new ParseField("trigger_count", new String[0]);
    static ParseField INDEX_TIME_IN_MS = new ParseField("index_time_in_ms", new String[0]);
    static ParseField SEARCH_TIME_IN_MS = new ParseField("search_time_in_ms", new String[0]);
    static ParseField PROCESSING_TIME_IN_MS = new ParseField("processing_time_in_ms", new String[0]);
    static ParseField DELETE_TIME_IN_MS = new ParseField("delete_time_in_ms", new String[0]);
    static ParseField INDEX_TOTAL = new ParseField("index_total", new String[0]);
    static ParseField SEARCH_TOTAL = new ParseField("search_total", new String[0]);
    static ParseField PROCESSING_TOTAL = new ParseField("processing_total", new String[0]);
    static ParseField SEARCH_FAILURES = new ParseField("search_failures", new String[0]);
    static ParseField INDEX_FAILURES = new ParseField("index_failures", new String[0]);
    public static final ConstructingObjectParser<TransformIndexerStats, Void> LENIENT_PARSER = new ConstructingObjectParser("transform_indexer_stats", true, args -> new TransformIndexerStats(TransformIndexerStats.unboxSafe(args[0], 0L), TransformIndexerStats.unboxSafe(args[1], 0L), TransformIndexerStats.unboxSafe(args[2], 0L), TransformIndexerStats.unboxSafe(args[3], 0L), TransformIndexerStats.unboxSafe(args[4], 0L), TransformIndexerStats.unboxSafe(args[5], 0L), TransformIndexerStats.unboxSafe(args[6], 0L), TransformIndexerStats.unboxSafe(args[7], 0L), TransformIndexerStats.unboxSafe(args[8], 0L), TransformIndexerStats.unboxSafe(args[9], 0L), TransformIndexerStats.unboxSafe(args[10], 0L), TransformIndexerStats.unboxSafe(args[11], 0L), TransformIndexerStats.unboxSafe(args[12], 0L), TransformIndexerStats.unboxSafe(args[13], 0L), TransformIndexerStats.unboxSafe(args[14], 0.0), TransformIndexerStats.unboxSafe(args[15], 0.0), TransformIndexerStats.unboxSafe(args[16], 0.0)));
    private final double expAvgCheckpointDurationMs;
    private final double expAvgDocumentsIndexed;
    private final double expAvgDocumentsProcessed;
    private final long pagesProcessed;
    private final long documentsProcessed;
    private final long documentsIndexed;
    private final long documentsDeleted;
    private final long triggerCount;
    private final long indexTime;
    private final long indexTotal;
    private final long searchTime;
    private final long searchTotal;
    private final long processingTime;
    private final long deleteTime;
    private final long processingTotal;
    private final long indexFailures;
    private final long searchFailures;

    public static TransformIndexerStats fromXContent(XContentParser parser) throws IOException {
        return LENIENT_PARSER.parse(parser, null);
    }

    public TransformIndexerStats(long pagesProcessed, long documentsProcessed, long documentsIndexed, long documentsDeleted, long triggerCount, long indexTime, long searchTime, long processingTime, long deleteTime, long indexTotal, long searchTotal, long processingTotal, long indexFailures, long searchFailures, double expAvgCheckpointDurationMs, double expAvgDocumentsIndexed, double expAvgDocumentsProcessed) {
        this.pagesProcessed = pagesProcessed;
        this.documentsProcessed = documentsProcessed;
        this.documentsIndexed = documentsIndexed;
        this.documentsDeleted = documentsDeleted;
        this.triggerCount = triggerCount;
        this.indexTime = indexTime;
        this.indexTotal = indexTotal;
        this.searchTime = searchTime;
        this.deleteTime = deleteTime;
        this.searchTotal = searchTotal;
        this.processingTime = processingTime;
        this.processingTotal = processingTotal;
        this.indexFailures = indexFailures;
        this.searchFailures = searchFailures;
        this.expAvgCheckpointDurationMs = expAvgCheckpointDurationMs;
        this.expAvgDocumentsIndexed = expAvgDocumentsIndexed;
        this.expAvgDocumentsProcessed = expAvgDocumentsProcessed;
    }

    public double getExpAvgCheckpointDurationMs() {
        return this.expAvgCheckpointDurationMs;
    }

    public double getExpAvgDocumentsIndexed() {
        return this.expAvgDocumentsIndexed;
    }

    public double getExpAvgDocumentsProcessed() {
        return this.expAvgDocumentsProcessed;
    }

    public long getPagesProcessed() {
        return this.pagesProcessed;
    }

    public long getDocumentsProcessed() {
        return this.documentsProcessed;
    }

    public long getTriggerCount() {
        return this.triggerCount;
    }

    public long getDocumentsIndexed() {
        return this.documentsIndexed;
    }

    @Deprecated
    public long getNumPages() {
        return this.getPagesProcessed();
    }

    @Deprecated
    public long getNumDocuments() {
        return this.getDocumentsProcessed();
    }

    @Deprecated
    public long getNumInvocations() {
        return this.getTriggerCount();
    }

    @Deprecated
    public long getOutputDocuments() {
        return this.getDocumentsIndexed();
    }

    public long getDocumentsDeleted() {
        return this.documentsDeleted;
    }

    public long getIndexFailures() {
        return this.indexFailures;
    }

    public long getSearchFailures() {
        return this.searchFailures;
    }

    public long getIndexTime() {
        return this.indexTime;
    }

    public long getSearchTime() {
        return this.searchTime;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public long getDeleteTime() {
        return this.deleteTime;
    }

    public long getIndexTotal() {
        return this.indexTotal;
    }

    public long getSearchTotal() {
        return this.searchTotal;
    }

    public long getProcessingTotal() {
        return this.processingTotal;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TransformIndexerStats that = (TransformIndexerStats)other;
        return Objects.equals(this.pagesProcessed, that.pagesProcessed) && Objects.equals(this.documentsProcessed, that.documentsProcessed) && Objects.equals(this.documentsIndexed, that.documentsIndexed) && Objects.equals(this.documentsDeleted, that.documentsDeleted) && Objects.equals(this.triggerCount, that.triggerCount) && Objects.equals(this.indexTime, that.indexTime) && Objects.equals(this.searchTime, that.searchTime) && Objects.equals(this.processingTime, that.processingTime) && Objects.equals(this.deleteTime, that.deleteTime) && Objects.equals(this.indexFailures, that.indexFailures) && Objects.equals(this.searchFailures, that.searchFailures) && Objects.equals(this.indexTotal, that.indexTotal) && Objects.equals(this.searchTotal, that.searchTotal) && Objects.equals(this.processingTotal, that.processingTotal) && Objects.equals(this.expAvgCheckpointDurationMs, that.expAvgCheckpointDurationMs) && Objects.equals(this.expAvgDocumentsIndexed, that.expAvgDocumentsIndexed) && Objects.equals(this.expAvgDocumentsProcessed, that.expAvgDocumentsProcessed);
    }

    public int hashCode() {
        return Objects.hash(this.pagesProcessed, this.documentsProcessed, this.documentsIndexed, this.documentsDeleted, this.triggerCount, this.indexTime, this.searchTime, this.processingTime, this.deleteTime, this.indexFailures, this.searchFailures, this.indexTotal, this.searchTotal, this.processingTotal, this.expAvgCheckpointDurationMs, this.expAvgDocumentsIndexed, this.expAvgDocumentsProcessed);
    }

    private static <T> T unboxSafe(Object l, T default_value) {
        if (l == null) {
            return default_value;
        }
        return (T)l;
    }

    static {
        LENIENT_PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), PAGES_PROCESSED);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), DOCUMENTS_PROCESSED);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), DOCUMENTS_INDEXED);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), DOCUMENTS_DELETED);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), TRIGGER_COUNT);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), INDEX_TIME_IN_MS);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), SEARCH_TIME_IN_MS);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), PROCESSING_TIME_IN_MS);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), DELETE_TIME_IN_MS);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), INDEX_TOTAL);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), SEARCH_TOTAL);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), PROCESSING_TOTAL);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), INDEX_FAILURES);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), SEARCH_FAILURES);
        LENIENT_PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), EXPONENTIAL_AVG_CHECKPOINT_DURATION_MS);
        LENIENT_PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), EXPONENTIAL_AVG_DOCUMENTS_INDEXED);
        LENIENT_PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), EXPONENTIAL_AVG_DOCUMENTS_PROCESSED);
    }
}

