/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.inference.preprocessing;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.client.ml.inference.preprocessing.PreProcessor;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class FrequencyEncoding
implements PreProcessor {
    public static final String NAME = "frequency_encoding";
    public static final ParseField FIELD = new ParseField("field", new String[0]);
    public static final ParseField FEATURE_NAME = new ParseField("feature_name", new String[0]);
    public static final ParseField FREQUENCY_MAP = new ParseField("frequency_map", new String[0]);
    public static final ParseField CUSTOM = new ParseField("custom", new String[0]);
    public static final ConstructingObjectParser<FrequencyEncoding, Void> PARSER = new ConstructingObjectParser("frequency_encoding", true, a -> new FrequencyEncoding((String)a[0], (String)a[1], (Map)a[2], (Boolean)a[3]));
    private final String field;
    private final String featureName;
    private final Map<String, Double> frequencyMap;
    private final Boolean custom;

    public static FrequencyEncoding fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    FrequencyEncoding(String field, String featureName, Map<String, Double> frequencyMap, Boolean custom) {
        this.field = Objects.requireNonNull(field);
        this.featureName = Objects.requireNonNull(featureName);
        this.frequencyMap = Collections.unmodifiableMap(Objects.requireNonNull(frequencyMap));
        this.custom = custom;
    }

    public String getField() {
        return this.field;
    }

    public Map<String, Double> getFrequencyMap() {
        return this.frequencyMap;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public Boolean getCustom() {
        return this.custom;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FIELD.getPreferredName(), this.field);
        builder.field(FEATURE_NAME.getPreferredName(), this.featureName);
        builder.field(FREQUENCY_MAP.getPreferredName(), this.frequencyMap);
        if (this.custom != null) {
            builder.field(CUSTOM.getPreferredName(), this.custom);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FrequencyEncoding that = (FrequencyEncoding)o;
        return Objects.equals(this.field, that.field) && Objects.equals(this.featureName, that.featureName) && Objects.equals(this.custom, that.custom) && Objects.equals(this.frequencyMap, that.frequencyMap);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.featureName, this.frequencyMap, this.custom);
    }

    public Builder builder(String fieldName) {
        return new Builder(fieldName);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), FEATURE_NAME);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(HashMap::new, XContentParser::doubleValue), FREQUENCY_MAP);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), CUSTOM);
    }

    public static class Builder {
        private String field;
        private String featureName;
        private Map<String, Double> frequencyMap = new HashMap<String, Double>();
        private Boolean custom;

        public Builder(String field) {
            this.field = field;
        }

        public Builder setField(String field) {
            this.field = field;
            return this;
        }

        public Builder setFeatureName(String featureName) {
            this.featureName = featureName;
            return this;
        }

        public Builder setFrequencyMap(Map<String, Double> frequencyMap) {
            this.frequencyMap = new HashMap<String, Double>(frequencyMap);
            return this;
        }

        public Builder addFrequency(String valueName, double frequency) {
            this.frequencyMap.put(valueName, frequency);
            return this;
        }

        public Builder setCustom(boolean custom) {
            this.custom = custom;
            return this;
        }

        public FrequencyEncoding build() {
            return new FrequencyEncoding(this.field, this.featureName, this.frequencyMap, this.custom);
        }
    }
}

