/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.dataframe.stats.outlierdetection;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class Parameters
implements ToXContentObject {
    public static final ParseField N_NEIGHBORS = new ParseField("n_neighbors", new String[0]);
    public static final ParseField METHOD = new ParseField("method", new String[0]);
    public static final ParseField FEATURE_INFLUENCE_THRESHOLD = new ParseField("feature_influence_threshold", new String[0]);
    public static final ParseField COMPUTE_FEATURE_INFLUENCE = new ParseField("compute_feature_influence", new String[0]);
    public static final ParseField OUTLIER_FRACTION = new ParseField("outlier_fraction", new String[0]);
    public static final ParseField STANDARDIZATION_ENABLED = new ParseField("standardization_enabled", new String[0]);
    public static ConstructingObjectParser<Parameters, Void> PARSER = new ConstructingObjectParser("outlier_detection_parameters", true, a -> new Parameters((Integer)a[0], (String)a[1], (Boolean)a[2], (Double)a[3], (Double)a[4], (Boolean)a[5]));
    private final Integer nNeighbors;
    private final String method;
    private final Boolean computeFeatureInfluence;
    private final Double featureInfluenceThreshold;
    private final Double outlierFraction;
    private final Boolean standardizationEnabled;

    public Parameters(Integer nNeighbors, String method, Boolean computeFeatureInfluence, Double featureInfluenceThreshold, Double outlierFraction, Boolean standardizationEnabled) {
        this.nNeighbors = nNeighbors;
        this.method = method;
        this.computeFeatureInfluence = computeFeatureInfluence;
        this.featureInfluenceThreshold = featureInfluenceThreshold;
        this.outlierFraction = outlierFraction;
        this.standardizationEnabled = standardizationEnabled;
    }

    public Integer getnNeighbors() {
        return this.nNeighbors;
    }

    public String getMethod() {
        return this.method;
    }

    public Boolean getComputeFeatureInfluence() {
        return this.computeFeatureInfluence;
    }

    public Double getFeatureInfluenceThreshold() {
        return this.featureInfluenceThreshold;
    }

    public Double getOutlierFraction() {
        return this.outlierFraction;
    }

    public Boolean getStandardizationEnabled() {
        return this.standardizationEnabled;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.nNeighbors != null) {
            builder.field(N_NEIGHBORS.getPreferredName(), this.nNeighbors);
        }
        if (this.method != null) {
            builder.field(METHOD.getPreferredName(), this.method);
        }
        if (this.computeFeatureInfluence != null) {
            builder.field(COMPUTE_FEATURE_INFLUENCE.getPreferredName(), this.computeFeatureInfluence);
        }
        if (this.featureInfluenceThreshold != null) {
            builder.field(FEATURE_INFLUENCE_THRESHOLD.getPreferredName(), this.featureInfluenceThreshold);
        }
        if (this.outlierFraction != null) {
            builder.field(OUTLIER_FRACTION.getPreferredName(), this.outlierFraction);
        }
        if (this.standardizationEnabled != null) {
            builder.field(STANDARDIZATION_ENABLED.getPreferredName(), this.standardizationEnabled);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Parameters that = (Parameters)o;
        return Objects.equals(this.nNeighbors, that.nNeighbors) && Objects.equals(this.method, that.method) && Objects.equals(this.computeFeatureInfluence, that.computeFeatureInfluence) && Objects.equals(this.featureInfluenceThreshold, that.featureInfluenceThreshold) && Objects.equals(this.outlierFraction, that.outlierFraction) && Objects.equals(this.standardizationEnabled, that.standardizationEnabled);
    }

    public int hashCode() {
        return Objects.hash(this.nNeighbors, this.method, this.computeFeatureInfluence, this.featureInfluenceThreshold, this.outlierFraction, this.standardizationEnabled);
    }

    static {
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), N_NEIGHBORS);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), METHOD);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), COMPUTE_FEATURE_INFLUENCE);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), FEATURE_INFLUENCE_THRESHOLD);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), OUTLIER_FRACTION);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), STANDARDIZATION_ENABLED);
    }
}

