/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.migration;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public class PostFeatureUpgradeResponse {
    private final boolean accepted;
    private final List<Feature> features;
    @Nullable
    private final String reason;
    @Nullable
    private final ElasticsearchException elasticsearchException;
    private static final ParseField ACCEPTED = new ParseField("accepted", new String[0]);
    private static final ParseField FEATURES = new ParseField("features", new String[0]);
    private static final ParseField REASON = new ParseField("reason", new String[0]);
    private static final ParseField ELASTICSEARCH_EXCEPTION = new ParseField("exception", new String[0]);
    private static final ConstructingObjectParser<PostFeatureUpgradeResponse, Void> PARSER = new ConstructingObjectParser<PostFeatureUpgradeResponse, Void>("post_feature_upgrade_response", true, (a, ctx) -> new PostFeatureUpgradeResponse((Boolean)a[0], (List)a[1], (String)a[2], (ElasticsearchException)a[3]));

    public static PostFeatureUpgradeResponse parse(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public PostFeatureUpgradeResponse(boolean accepted, List<Feature> features, @Nullable String reason, @Nullable ElasticsearchException elasticsearchException) {
        this.accepted = accepted;
        this.features = Objects.nonNull(features) ? features : Collections.emptyList();
        this.reason = reason;
        this.elasticsearchException = elasticsearchException;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public List<Feature> getFeatures() {
        return Objects.isNull(this.features) ? Collections.emptyList() : this.features;
    }

    @Nullable
    public String getReason() {
        return this.reason;
    }

    @Nullable
    public ElasticsearchException getElasticsearchException() {
        return this.elasticsearchException;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostFeatureUpgradeResponse that = (PostFeatureUpgradeResponse)o;
        return this.accepted == that.accepted && Objects.equals(this.features, that.features) && Objects.equals(this.reason, that.reason);
    }

    public int hashCode() {
        return Objects.hash(this.accepted, this.features, this.reason);
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> p.booleanValue(), ACCEPTED, ObjectParser.ValueType.BOOLEAN);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), Feature::parse, FEATURES);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.text(), REASON, ObjectParser.ValueType.STRING);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ElasticsearchException.fromXContent(p), ELASTICSEARCH_EXCEPTION);
    }

    public static class Feature {
        private final String featureName;
        private static final ParseField FEATURE_NAME = new ParseField("feature_name", new String[0]);
        private static final ConstructingObjectParser<Feature, Void> PARSER = new ConstructingObjectParser<Feature, Void>("feature", true, (a, ctx) -> new Feature((String)a[0]));

        public static Feature parse(XContentParser parser, Void ctx) {
            return PARSER.apply(parser, ctx);
        }

        public Feature(String featureName) {
            this.featureName = featureName;
        }

        public String getFeatureName() {
            return this.featureName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Feature feature = (Feature)o;
            return Objects.equals(this.featureName, feature.featureName);
        }

        public int hashCode() {
            return Objects.hash(this.featureName);
        }

        static {
            PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> p.text(), FEATURE_NAME, ObjectParser.ValueType.STRING);
        }
    }
}

