/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class GeoIpStatsResponse
implements ToXContentObject {
    private static final ConstructingObjectParser<GeoIpStatsResponse, Void> PARSER = new ConstructingObjectParser("geoip_stats", a -> {
        Map stats = (Map)a[0];
        List nodes = (List)a[1];
        return new GeoIpStatsResponse((Integer)stats.get("successful_downloads"), (Integer)stats.get("failed_downloads"), ((Number)stats.get("total_download_time")).longValue(), (Integer)stats.get("databases_count"), (Integer)stats.get("skipped_updates"), nodes.stream().collect(Collectors.toMap(Tuple::v1, Tuple::v2)));
    });
    private final int successfulDownloads;
    private final int failedDownloads;
    private final long totalDownloadTime;
    private final int databasesCount;
    private final int skippedDownloads;
    private final Map<String, NodeInfo> nodes;

    public GeoIpStatsResponse(int successfulDownloads, int failedDownloads, long totalDownloadTime, int databasesCount, int skippedDownloads, Map<String, NodeInfo> nodes) {
        this.successfulDownloads = successfulDownloads;
        this.failedDownloads = failedDownloads;
        this.totalDownloadTime = totalDownloadTime;
        this.databasesCount = databasesCount;
        this.skippedDownloads = skippedDownloads;
        this.nodes = nodes;
    }

    public int getSuccessfulDownloads() {
        return this.successfulDownloads;
    }

    public int getFailedDownloads() {
        return this.failedDownloads;
    }

    public long getTotalDownloadTime() {
        return this.totalDownloadTime;
    }

    public int getDatabasesCount() {
        return this.databasesCount;
    }

    public int getSkippedDownloads() {
        return this.skippedDownloads;
    }

    public Map<String, NodeInfo> getNodes() {
        return this.nodes;
    }

    public static GeoIpStatsResponse fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoIpStatsResponse that = (GeoIpStatsResponse)o;
        return this.successfulDownloads == that.successfulDownloads && this.failedDownloads == that.failedDownloads && this.totalDownloadTime == that.totalDownloadTime && this.databasesCount == that.databasesCount && this.skippedDownloads == that.skippedDownloads && this.nodes.equals(that.nodes);
    }

    public int hashCode() {
        return Objects.hash(this.successfulDownloads, this.failedDownloads, this.totalDownloadTime, this.databasesCount, this.skippedDownloads, this.nodes);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject("stats");
        builder.field("successful_downloads", this.successfulDownloads);
        builder.field("failed_downloads", this.failedDownloads);
        builder.field("skipped_updates", this.skippedDownloads);
        builder.field("total_download_time", this.totalDownloadTime);
        builder.field("databases_count", this.databasesCount);
        builder.endObject();
        builder.field("nodes", this.nodes);
        builder.endObject();
        return builder;
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(), new ParseField("stats", new String[0]));
        PARSER.declareNamedObjects(ConstructingObjectParser.constructorArg(), (p, c, name) -> Tuple.tuple(name, (NodeInfo)NodeInfo.PARSER.apply(p, c)), new ParseField("nodes", new String[0]));
    }

    public static final class NodeInfo
    implements ToXContentObject {
        private static final ConstructingObjectParser<NodeInfo, Void> PARSER = new ConstructingObjectParser("node_info", a -> {
            List databases = (List)a[1];
            return new NodeInfo((Collection)a[0], databases.stream().collect(Collectors.toMap(DatabaseInfo::getName, Function.identity())));
        });
        private final List<String> filesInTemp;
        private final Map<String, DatabaseInfo> databases;

        public NodeInfo(Collection<String> filesInTemp, Map<String, DatabaseInfo> databases) {
            this.filesInTemp = org.elasticsearch.core.List.copyOf(filesInTemp);
            this.databases = org.elasticsearch.core.Map.copyOf(databases);
        }

        public List<String> getFilesInTemp() {
            return this.filesInTemp;
        }

        public Map<String, DatabaseInfo> getDatabases() {
            return this.databases;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.stringListField("files_in_temp", this.filesInTemp);
            builder.field("databases", this.databases.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).collect(Collectors.toList()));
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeInfo nodeInfo = (NodeInfo)o;
            return this.filesInTemp.equals(nodeInfo.filesInTemp) && this.databases.equals(nodeInfo.databases);
        }

        public int hashCode() {
            return Objects.hash(this.filesInTemp, this.databases);
        }

        static {
            PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), new ParseField("files_in_temp", new String[0]));
            PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), DatabaseInfo.PARSER, new ParseField("databases", new String[0]));
        }
    }

    public static final class DatabaseInfo
    implements ToXContentObject {
        private static final ConstructingObjectParser<DatabaseInfo, Void> PARSER = new ConstructingObjectParser("database_info", a -> new DatabaseInfo((String)a[0]));
        private final String name;

        public DatabaseInfo(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("name", this.name);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DatabaseInfo that = (DatabaseInfo)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("name", new String[0]));
        }
    }
}

