/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.elastic.impl;

import java.io.Serializable;
import javax.annotation.Nonnull;

class Shard
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String index;
    private final int shard;
    private final Prirep prirep;
    private final int docs;
    private final String state;
    private final String ip;
    private final String httpAddress;
    private final String node;

    Shard(@Nonnull String index, int shard, @Nonnull Prirep prirep, int docs, @Nonnull String state, @Nonnull String ip, @Nonnull String httpAddress, @Nonnull String node) {
        this.index = index;
        this.shard = shard;
        this.prirep = prirep;
        this.docs = docs;
        this.state = state;
        this.ip = ip;
        this.httpAddress = httpAddress;
        this.node = node;
    }

    public String indexShard() {
        return this.index + "-" + this.shard;
    }

    public String getIndex() {
        return this.index;
    }

    public int getShard() {
        return this.shard;
    }

    public Prirep getPrirep() {
        return this.prirep;
    }

    public int getDocs() {
        return this.docs;
    }

    public String getState() {
        return this.state;
    }

    public String getIp() {
        return this.ip;
    }

    public String getHttpAddress() {
        return this.httpAddress;
    }

    public String getNode() {
        return this.node;
    }

    public String toString() {
        return "Shard{index='" + this.index + "', shard=" + this.shard + ", prirep=" + String.valueOf((Object)this.prirep) + ", docs=" + this.docs + ", state='" + this.state + "', ip='" + this.ip + "', httpAddress='" + this.httpAddress + "', node='" + this.node + "'}";
    }

    public static enum Prirep {
        p,
        r;

    }
}

