/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.elastic.impl;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.IOException;
import java.util.concurrent.Callable;

public final class RetryUtils {
    private static final ILogger LOGGER = Logger.getLogger(RetryUtils.class);
    private static final long MAX_BACKOFF_MS = 300000L;
    private static final long MS_IN_SECOND = 1000L;

    private RetryUtils() {
    }

    public static <T> T withRetry(Callable<T> callable, int retries) {
        return RetryUtils.withRetry(callable, retries, IOException.class);
    }

    @SafeVarargs
    public static <T> T withRetry(Callable<T> callable, int retries, Class<? extends Exception> ... exceptions) {
        int retryCount = 0;
        while (true) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                if (RetryUtils.anyOf(e, exceptions)) {
                    if (++retryCount > retries) {
                        throw ExceptionUtil.sneakyThrow((Throwable)e);
                    }
                    long waitIntervalMs = Math.min(300000L, 1000L * (long)(1 << retryCount));
                    LOGGER.fine(String.format("Couldn't connect to Elastic, [%s] retrying in %s seconds...", retryCount, waitIntervalMs / 1000L));
                    RetryUtils.sleep(waitIntervalMs);
                    continue;
                }
                throw ExceptionUtil.sneakyThrow((Throwable)e);
            }
            break;
        }
    }

    private static boolean anyOf(Exception e, Class<? extends Exception>[] exceptions) {
        for (Class<? extends Exception> exception : exceptions) {
            Throwable throwable;
            if (exception.isAssignableFrom(e.getClass())) {
                return true;
            }
            if (e.getCause() == null || !((throwable = e.getCause()) instanceof Exception)) continue;
            Exception cause = (Exception)throwable;
            if (e.getCause() == e) continue;
            return RetryUtils.anyOf(cause, exceptions);
        }
        return false;
    }

    private static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new HazelcastException((Throwable)e);
        }
    }
}

