/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.elastic.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.processor.Processors;
import com.hazelcast.jet.elastic.impl.ElasticCatClient;
import com.hazelcast.jet.elastic.impl.ElasticSourceConfiguration;
import com.hazelcast.jet.elastic.impl.ElasticSourcePSupplier;
import com.hazelcast.jet.elastic.impl.Shard;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.RestHighLevelClient;

public class ElasticSourcePMetaSupplier<T>
implements ProcessorMetaSupplier {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_LOCAL_PARALLELISM = 2;
    @Nonnull
    private final ElasticSourceConfiguration<T> configuration;
    private transient Map<Address, List<Shard>> assignedShards;
    private transient Address ownerAddress;

    public ElasticSourcePMetaSupplier(@Nonnull ElasticSourceConfiguration<T> configuration) {
        this.configuration = configuration;
    }

    public int preferredLocalParallelism() {
        if (this.configuration.isCoLocatedReadingEnabled() || this.configuration.isSlicingEnabled()) {
            return 2;
        }
        return 1;
    }

    public void init(@Nonnull ProcessorMetaSupplier.Context context) throws Exception {
        try (ElasticCatClient catClient = new ElasticCatClient(((RestHighLevelClient)this.configuration.clientFn().get()).getLowLevelClient(), this.configuration.retries());){
            List<Shard> shards = catClient.shards(((SearchRequest)this.configuration.searchRequestFn().get()).indices());
            if (this.configuration.isCoLocatedReadingEnabled()) {
                Set<Address> addresses = context.partitionAssignment().keySet();
                this.assignedShards = ElasticSourcePMetaSupplier.assignShards(shards, addresses);
            } else {
                this.ownerAddress = ProcessorMetaSupplier.getOwnerAddress((ProcessorMetaSupplier.Context)context, (Object)context.jobId());
                this.assignedShards = Collections.emptyMap();
            }
        }
    }

    static Map<Address, List<Shard>> assignShards(Collection<Shard> shards, Collection<Address> addresses) {
        Map assignment = addresses.stream().map(Address::getHost).distinct().collect(Collectors.toMap(Function.identity(), a -> new ArrayList()));
        Map nodeCandidates = shards.stream().collect(Collectors.groupingBy(Shard::indexShard, Collectors.mapping(Shard::getIp, Collectors.toList())));
        nodeCandidates.forEach((indexShard, hosts) -> hosts.stream().map(assignment::get).filter(Objects::nonNull).min(Comparator.comparingInt(List::size)).orElseThrow(() -> new IllegalStateException("Selected members do not contain shard '" + indexShard + "'")).add(indexShard));
        Map addressMap = addresses.stream().collect(Collectors.groupingBy(Address::getHost, Collectors.toList()));
        Map shardMap = shards.stream().collect(Collectors.toMap(s -> s.indexShard() + "@" + s.getIp(), Function.identity()));
        return assignment.entrySet().stream().flatMap(e -> {
            List a = (List)addressMap.get(e.getKey());
            List<Shard> s = ((List)e.getValue()).stream().map(indexShard -> (Shard)shardMap.get(indexShard + "@" + (String)e.getKey())).toList();
            int c = (int)Math.ceil((double)s.size() / (double)a.size());
            return IntStream.range(0, a.size()).mapToObj(i -> Map.entry((Address)a.get(i), List.copyOf(s.subList(i * c, Math.min((i + 1) * c, s.size())))));
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Nonnull
    public Function<? super Address, ? extends ProcessorSupplier> get(@Nonnull List<Address> addresses) {
        if (this.configuration.isSlicingEnabled() || this.configuration.isCoLocatedReadingEnabled()) {
            return address -> {
                List<Shard> shards = this.assignedShards.getOrDefault(address, Collections.emptyList());
                return new ElasticSourcePSupplier<T>(this.configuration, shards);
            };
        }
        return address -> address.equals((Object)this.ownerAddress) ? new ElasticSourcePSupplier<T>(this.configuration, Collections.emptyList()) : count -> Collections.nCopies(count, (Processor)Processors.noopP().get());
    }

    public boolean closeIsCooperative() {
        return true;
    }
}

