/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.elastic.impl;

import com.hazelcast.internal.json.Json;
import com.hazelcast.internal.json.JsonArray;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.json.JsonValue;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.elastic.impl.RetryUtils;
import com.hazelcast.jet.elastic.impl.Shard;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;

public class ElasticCatClient
implements Closeable {
    private static final ILogger LOG = Logger.getLogger(ElasticCatClient.class);
    private final RestClient client;
    private final int retries;

    public ElasticCatClient(RestClient client, int retries) {
        this.client = client;
        this.retries = retries;
    }

    public Master master() {
        Master master;
        Request r = new Request("GET", "/_cat/master");
        r.addParameter("format", "json");
        Response res = RetryUtils.withRetry(() -> this.client.performRequest(r), this.retries);
        InputStreamReader reader = new InputStreamReader(res.getEntity().getContent(), StandardCharsets.UTF_8);
        try {
            JsonArray array = Json.parse((Reader)reader).asArray();
            JsonObject object = array.get(0).asObject();
            master = new Master(object.get("host").asString(), object.get("id").asString(), object.get("ip").asString(), object.get("node").asString());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new JetException("Could not get ES cluster master", (Throwable)e);
            }
        }
        reader.close();
        return master;
    }

    public List<Node> nodes() {
        ArrayList arrayList;
        Request r = new Request("GET", "/_cat/nodes");
        r.addParameter("format", "json");
        r.addParameter("full_id", "true");
        r.addParameter("h", "id,ip,name,http_address,master");
        Response res = RetryUtils.withRetry(() -> this.client.performRequest(r), this.retries);
        InputStreamReader reader = new InputStreamReader(res.getEntity().getContent(), StandardCharsets.UTF_8);
        try {
            JsonArray array = Json.parse((Reader)reader).asArray();
            ArrayList nodes = new ArrayList(array.size());
            for (JsonValue value : array) {
                Optional<Node> shard = this.convertToNode(value);
                shard.ifPresent(nodes::add);
            }
            LOG.fine("Nodes: " + String.valueOf(nodes));
            arrayList = nodes;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new JetException("Could not get ES cluster nodes", (Throwable)e);
            }
        }
        reader.close();
        return arrayList;
    }

    private Optional<Node> convertToNode(JsonValue value) {
        JsonObject object = value.asObject();
        return Optional.of(new Node(object.get("id").asString(), object.get("ip").asString(), object.get("name").asString(), object.get("http_address").asString(), object.get("master").asString()));
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    public List<Shard> shards(String ... indices) {
        ArrayList arrayList;
        Map<String, String> idToAddress = this.nodes().stream().collect(Collectors.toMap(Node::getId, Node::getHttpAddress));
        Request r = new Request("GET", "/_cat/shards/" + String.join((CharSequence)",", indices));
        r.addParameter("format", "json");
        r.addParameter("h", "id,index,shard,prirep,docs,state,ip,node");
        Response res = RetryUtils.withRetry(() -> this.client.performRequest(r), this.retries);
        InputStreamReader reader = new InputStreamReader(res.getEntity().getContent(), StandardCharsets.UTF_8);
        try {
            JsonArray array = Json.parse((Reader)reader).asArray();
            ArrayList shards = new ArrayList(array.size());
            for (JsonValue value : array) {
                Optional<Shard> shard = this.convertToShard(value, idToAddress);
                shard.ifPresent(shards::add);
            }
            LOG.log(Level.FINE, "Shards " + String.valueOf(shards));
            arrayList = shards;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new JetException("Could not get ES shards", (Throwable)e);
            }
        }
        reader.close();
        return arrayList;
    }

    private Optional<Shard> convertToShard(JsonValue value, Map<String, String> idToAddress) {
        JsonObject object = value.asObject();
        if ("STARTED".equals(object.get("state").asString())) {
            String id = object.get("id").asString();
            JsonValue docsValue = object.get("docs");
            int docsCount = docsValue != null && !docsValue.equals((Object)Json.NULL) ? Integer.parseInt(docsValue.asString()) : 0;
            Shard shard = new Shard(object.get("index").asString(), Integer.parseInt(object.get("shard").asString()), Shard.Prirep.valueOf(object.get("prirep").asString()), docsCount, object.get("state").asString(), object.get("ip").asString(), idToAddress.get(id), object.get("node").asString());
            return Optional.of(shard);
        }
        return Optional.empty();
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    public static class Master {
        private final String host;
        private final String id;
        private final String ip;
        private final String node;

        public Master(String host, String id, String ip, String node) {
            this.host = host;
            this.id = id;
            this.ip = ip;
            this.node = node;
        }

        public String getHost() {
            return this.host;
        }

        public String getId() {
            return this.id;
        }

        public String getIp() {
            return this.ip;
        }

        public String getNode() {
            return this.node;
        }

        public String toString() {
            return "Master{host='" + this.host + "', id='" + this.id + "', ip='" + this.ip + "', node='" + this.node + "'}";
        }
    }

    public static class Node {
        private final String id;
        private final String ip;
        private final String name;
        private final String httpAddress;
        private final String master;

        public Node(@Nonnull String id, @Nonnull String ip, @Nonnull String name, @Nonnull String httpAddress, @Nonnull String master) {
            this.id = id;
            this.ip = ip;
            this.name = name;
            this.httpAddress = httpAddress;
            this.master = master;
        }

        public String getId() {
            return this.id;
        }

        public String getIp() {
            return this.ip;
        }

        public String getName() {
            return this.name;
        }

        public String getHttpAddress() {
            return this.httpAddress;
        }

        public String getMaster() {
            return this.master;
        }

        public String toString() {
            return "Node{ip='" + this.ip + "', name='" + this.name + "', httpAddress='" + this.httpAddress + "', master='" + this.master + "'}";
        }
    }
}

