/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.lz4;

import java.nio.ByteBuffer;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.elasticsearch.lz4.LZ4SafeUtils;
import org.elasticsearch.lz4.SafeUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ESLZ4Decompressor
extends LZ4FastDecompressor {
    public static final LZ4FastDecompressor INSTANCE = new ESLZ4Decompressor();

    ESLZ4Decompressor() {
    }

    @Override
    public int decompress(byte[] src, int srcOff, byte[] dest, int destOff, int destLen) {
        SafeUtils.checkRange(src, srcOff);
        SafeUtils.checkRange(dest, destOff, destLen);
        if (destLen == 0) {
            if (SafeUtils.readByte(src, srcOff) != 0) {
                throw new LZ4Exception("Malformed input at " + srcOff);
            }
            return 1;
        }
        int destEnd = destOff + destLen;
        int sOff = srcOff;
        int dOff = destOff;
        while (true) {
            int matchCopyEnd;
            int literalCopyEnd;
            int token = SafeUtils.readByte(src, sOff) & 0xFF;
            ++sOff;
            int literalLen = token >>> 4;
            if (literalLen == 15) {
                byte len;
                boolean var11 = true;
                while ((len = SafeUtils.readByte(src, sOff++)) == -1) {
                    literalLen += 255;
                }
                literalLen += len & 0xFF;
            }
            if ((literalCopyEnd = dOff + literalLen) > destEnd - 8) {
                if (literalCopyEnd != destEnd) {
                    throw new LZ4Exception("Malformed input at " + sOff);
                }
                LZ4SafeUtils.safeArraycopy(src, sOff, dest, dOff, literalLen);
                return (sOff += literalLen) - srcOff;
            }
            LZ4SafeUtils.wildArraycopy(src, sOff, dest, dOff, literalLen);
            int matchDec = SafeUtils.readShortLE(src, sOff += literalLen);
            sOff += 2;
            int matchOff = literalCopyEnd - matchDec;
            if (matchOff < destOff) {
                throw new LZ4Exception("Malformed input at " + sOff);
            }
            int matchLen = token & 0xF;
            if (matchLen == 15) {
                byte len;
                boolean var15 = true;
                while ((len = SafeUtils.readByte(src, sOff++)) == -1) {
                    matchLen += 255;
                }
                matchLen += len & 0xFF;
            }
            if ((matchCopyEnd = literalCopyEnd + (matchLen += 4)) > destEnd - 8) {
                if (matchCopyEnd > destEnd) {
                    throw new LZ4Exception("Malformed input at " + sOff);
                }
                LZ4SafeUtils.safeIncrementalCopy(dest, matchOff, literalCopyEnd, matchLen);
            } else {
                LZ4SafeUtils.wildIncrementalCopy(dest, matchOff, literalCopyEnd, matchCopyEnd);
            }
            dOff = matchCopyEnd;
        }
    }

    @Override
    public int decompress(ByteBuffer src, int srcOff, ByteBuffer dest, int destOff, int destLen) {
        if (src.hasArray() && dest.hasArray()) {
            return this.decompress(src.array(), srcOff + src.arrayOffset(), dest.array(), destOff + dest.arrayOffset(), destLen);
        }
        throw new AssertionError((Object)"Do not support decompression on direct buffers");
    }
}

