/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.adapter.enumerable;

import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.com.google.common.collect.Ordering;
import com.hazelcast.shaded.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import com.hazelcast.shaded.org.apache.calcite.adapter.enumerable.EnumerableRel;
import com.hazelcast.shaded.org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import com.hazelcast.shaded.org.apache.calcite.adapter.enumerable.PhysType;
import com.hazelcast.shaded.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import com.hazelcast.shaded.org.apache.calcite.adapter.enumerable.RexImpTable;
import com.hazelcast.shaded.org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import com.hazelcast.shaded.org.apache.calcite.adapter.java.JavaTypeFactory;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.BlockBuilder;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.Expression;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.Expressions;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.Primitive;
import com.hazelcast.shaded.org.apache.calcite.plan.DeriveMode;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.shaded.org.apache.calcite.plan.RelTrait;
import com.hazelcast.shaded.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.shaded.org.apache.calcite.rel.RelCollationTraitDef;
import com.hazelcast.shaded.org.apache.calcite.rel.RelDistributionTraitDef;
import com.hazelcast.shaded.org.apache.calcite.rel.RelFieldCollation;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Values;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.RelMdCollation;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.RelMdDistribution;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.shaded.org.apache.calcite.rex.RexLiteral;
import com.hazelcast.shaded.org.apache.calcite.util.BuiltInMethod;
import com.hazelcast.shaded.org.apache.calcite.util.Pair;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class EnumerableValues
extends Values
implements EnumerableRel {
    private EnumerableValues(RelOptCluster cluster, RelDataType rowType, ImmutableList<ImmutableList<RexLiteral>> tuples, RelTraitSet traitSet) {
        super(cluster, rowType, tuples, traitSet);
    }

    public static EnumerableValues create(RelOptCluster cluster, RelDataType rowType, ImmutableList<ImmutableList<RexLiteral>> tuples) {
        RelMetadataQuery mq = cluster.getMetadataQuery();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE).replaceIfs(RelCollationTraitDef.INSTANCE, () -> RelMdCollation.values(mq, rowType, tuples)).replaceIf(RelDistributionTraitDef.INSTANCE, () -> RelMdDistribution.values(rowType, tuples));
        return new EnumerableValues(cluster, rowType, tuples, traitSet);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.isEmpty());
        return new EnumerableValues(this.getCluster(), this.getRowType(), this.tuples, traitSet);
    }

    @Override
    public @Nullable RelNode passThrough(RelTraitSet required) {
        Object collation = required.getCollation();
        if (collation == null || collation.isDefault()) {
            return null;
        }
        if (this.tuples.size() > 1) {
            Ordering<List<RexLiteral>> ordering = null;
            for (RelFieldCollation fc : collation.getFieldCollations()) {
                Ordering<List<RexLiteral>> comparator = RelMdCollation.comparator(fc);
                if (ordering == null) {
                    ordering = comparator;
                    continue;
                }
                ordering = ordering.compound(comparator);
            }
            if (!((Ordering)Objects.requireNonNull(ordering, "ordering")).isOrdered(this.tuples)) {
                return null;
            }
        }
        return this.copy(this.traitSet.replace((RelTrait)collation), ImmutableList.of());
    }

    @Override
    public DeriveMode getDeriveMode() {
        return DeriveMode.PROHIBITED;
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        JavaTypeFactory typeFactory = (JavaTypeFactory)this.getCluster().getTypeFactory();
        BlockBuilder builder = new BlockBuilder();
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), pref.preferCustom());
        Type rowClass = physType.getJavaRowType();
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        List<RelDataTypeField> fields = this.getRowType().getFieldList();
        for (List tuple : this.tuples) {
            ArrayList<Expression> literals = new ArrayList<Expression>();
            for (Pair pair : Pair.zip(fields, tuple)) {
                literals.add(RexToLixTranslator.translateLiteral((RexLiteral)pair.right, ((RelDataTypeField)pair.left).getType(), typeFactory, RexImpTable.NullAs.NULL));
            }
            expressions.add(physType.record(literals));
        }
        builder.add(Expressions.return_(null, Expressions.call(BuiltInMethod.AS_ENUMERABLE.method, Expressions.newArrayInit(Primitive.box(rowClass), expressions))));
        return implementor.result(physType, builder.toBlock());
    }
}

