/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.processors;

import com.hazelcast.function.ToLongFunctionEx;
import com.hazelcast.jet.sql.impl.processors.StreamToStreamJoinBuffer;
import com.hazelcast.sql.impl.row.JetSqlRow;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

class StreamToStreamJoinListBuffer
extends StreamToStreamJoinBuffer {
    private final List<JetSqlRow> buffer = new LinkedList<JetSqlRow>();

    StreamToStreamJoinListBuffer(List<Map.Entry<Byte, ToLongFunctionEx<JetSqlRow>>> timeExtractors) {
        super(timeExtractors);
    }

    @Override
    public void add(JetSqlRow row) {
        this.buffer.add(row);
    }

    @Override
    public Iterator<JetSqlRow> iterator() {
        return this.buffer.iterator();
    }

    @Override
    public int size() {
        return this.buffer.size();
    }

    @Override
    public boolean isEmpty() {
        return this.buffer.isEmpty();
    }

    @Override
    public Collection<JetSqlRow> content() {
        return this.buffer;
    }

    @Override
    public void clearExpiredItems(long[] limits, @Nonnull Consumer<JetSqlRow> clearedRowsConsumer) {
        Iterator<JetSqlRow> iterator = this.buffer.iterator();
        long[] times = new long[this.timeExtractors.size()];
        while (iterator.hasNext()) {
            JetSqlRow row = iterator.next();
            boolean remove = false;
            for (int idx = 0; idx < this.timeExtractors.size(); ++idx) {
                times[idx] = ((ToLongFunctionEx)((Map.Entry)this.timeExtractors.get(idx)).getValue()).applyAsLong((Object)row);
                if (times[idx] >= limits[idx]) continue;
                remove = true;
            }
            if (!remove) continue;
            iterator.remove();
            clearedRowsConsumer.accept(row);
        }
    }
}

