/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.parse;

import com.hazelcast.jet.sql.impl.parse.ParserResource;
import com.hazelcast.jet.sql.impl.validate.ValidationUtil;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDrop;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSpecialOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.shaded.org.apache.calcite.util.ImmutableNullableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SqlDropDataConnection
extends SqlDrop {
    public static final SqlSpecialOperator DROP_DATA_CONNECTION = new SqlSpecialOperator("DROP DATA CONNECTION", SqlKind.OTHER_DDL);
    private final SqlIdentifier name;

    public SqlDropDataConnection(SqlIdentifier name, boolean ifExists, SqlParserPos pos) {
        super(DROP_DATA_CONNECTION, pos, ifExists);
        this.name = Objects.requireNonNull(name, "Name should not be null");
    }

    public String name() {
        return this.name.toString();
    }

    public boolean ifExists() {
        return this.ifExists;
    }

    @Override
    @Nonnull
    public SqlOperator getOperator() {
        return DROP_DATA_CONNECTION;
    }

    @Override
    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.name);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("DROP DATA CONNECTION");
        if (this.ifExists) {
            writer.keyword("IF EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        if (!ValidationUtil.isCatalogObjectNameValid(this.name)) {
            throw validator.newValidationError(this.name, ParserResource.RESOURCE.droppedDataConnectionDoesNotExist(this.name.toString()));
        }
    }
}

