/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.logical;

import com.hazelcast.jet.sql.impl.connector.HazelcastRexNode;
import com.hazelcast.jet.sql.impl.connector.SqlConnectorUtil;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.logical.DeleteByKeyMapLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.DeleteLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.ImmutableDeleteWithScanLogicalRule;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.shaded.org.apache.calcite.plan.RelRule;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.core.TableModify;
import com.hazelcast.shaded.org.apache.calcite.rel.core.TableScan;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.sql.impl.schema.map.PartitionedMapTable;
import org.immutables.value.Value;

@Value.Enclosing
class DeleteWithScanLogicalRule
extends RelRule<RelRule.Config> {
    static final RelOptRule INSTANCE = Config.DEFAULT.toRule();

    DeleteWithScanLogicalRule(RelRule.Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RexNode keyCondition;
        TableModify delete = (TableModify)call.rel(0);
        TableScan scan = (TableScan)call.rel(1);
        if (!OptUtils.requiresJob(delete) && OptUtils.hasTableType(scan, PartitionedMapTable.class) && (keyCondition = OptUtils.extractKeyConstantExpression(scan.getTable(), delete.getCluster().getRexBuilder())) != null) {
            DeleteByKeyMapLogicalRel rel = new DeleteByKeyMapLogicalRel(delete.getCluster(), OptUtils.toLogicalConvention(delete.getTraitSet()), scan.getTable(), keyCondition);
            call.transformTo(rel);
            return;
        }
        HazelcastTable hzTable = OptUtils.extractHazelcastTable(scan);
        Object connector = SqlConnectorUtil.getJetSqlConnector(hzTable.getTarget());
        if (connector.dmlSupportsPredicates() && (hzTable.getFilter() == null || connector.supportsExpression(HazelcastRexNode.wrap(hzTable.getFilter())))) {
            DeleteLogicalRel rel = new DeleteLogicalRel(delete.getCluster(), OptUtils.toLogicalConvention(delete.getTraitSet()), delete.getTable(), delete.getCatalogReader(), null, delete.isFlattened(), hzTable.getFilter());
            call.transformTo(rel);
            return;
        }
        DeleteLogicalRel logicalDelete = new DeleteLogicalRel(delete.getCluster(), OptUtils.toLogicalConvention(delete.getTraitSet()), delete.getTable(), delete.getCatalogReader(), OptUtils.toLogicalInput(delete.getInput()), delete.isFlattened(), null);
        RelNode newRel = call.builder().push(scan).push(logicalDelete).build();
        call.transformTo(newRel);
    }

    @Value.Immutable
    static interface Config
    extends RelRule.Config {
        public static final RelRule.Config DEFAULT = ImmutableDeleteWithScanLogicalRule.Config.builder().description(DeleteWithScanLogicalRule.class.getSimpleName()).operandSupplier(b0 -> b0.operand(TableModify.class).predicate(TableModify::isDelete).inputs(b1 -> b1.operand(TableScan.class).noInputs())).build();

        @Override
        default public RelOptRule toRule() {
            return new DeleteWithScanLogicalRule(this);
        }
    }
}

