/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc.mssql;

import com.hazelcast.jet.sql.impl.connector.jdbc.DefaultTypeResolver;
import com.hazelcast.jet.sql.impl.connector.jdbc.TypeResolver;
import com.hazelcast.jet.sql.impl.validate.operators.string.HazelcastConcatOperator;
import com.hazelcast.jet.sql.impl.validate.operators.string.HazelcastStringFunction;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDialect;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.dialect.MssqlSqlDialect;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.Locale;

public class HazelcastMSSQLDialect
extends MssqlSqlDialect
implements TypeResolver {
    public HazelcastMSSQLDialect(SqlDialect.Context context) {
        super(context);
    }

    @Override
    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        switch (call.getKind()) {
            case OTHER: {
                if (call.getOperator() instanceof HazelcastConcatOperator) {
                    this.unparseConcat(writer, call);
                    break;
                }
                super.unparseCall(writer, call, leftPrec, rightPrec);
                break;
            }
            case OTHER_FUNCTION: {
                if (HazelcastMSSQLDialect.isLengthFunction(call)) {
                    this.unparseLength(writer, call);
                    break;
                }
                super.unparseCall(writer, call, leftPrec, rightPrec);
                break;
            }
            default: {
                super.unparseCall(writer, call, leftPrec, rightPrec);
            }
        }
    }

    private void unparseConcat(SqlWriter writer, SqlCall call) {
        writer.print("CONCAT");
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.PARENTHESES, "(", ")");
        for (SqlNode operand : call.getOperandList()) {
            writer.sep(",");
            operand.unparse(writer, 0, 0);
        }
        writer.endList(frame);
    }

    private static boolean isLengthFunction(SqlCall basicCall) {
        return basicCall.getOperator() instanceof HazelcastStringFunction && basicCall.getOperator().getName().equals("LENGTH");
    }

    private void unparseLength(SqlWriter writer, SqlCall call) {
        writer.print("LEN");
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.PARENTHESES, "(", ")");
        for (SqlNode operand : call.getOperandList()) {
            writer.sep(",");
            operand.unparse(writer, 0, 0);
        }
        writer.endList(frame);
    }

    @Override
    public QueryDataType resolveType(String columnTypeName, int precision, int scale) {
        return switch (columnTypeName.toUpperCase(Locale.ROOT)) {
            case "FLOAT" -> QueryDataType.DOUBLE;
            case "DATETIME2", "SMALLDATETIME" -> QueryDataType.TIMESTAMP;
            default -> DefaultTypeResolver.resolveType(columnTypeName, precision, scale);
        };
    }
}

