/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc.join;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.jet.sql.impl.ExpressionUtil;
import com.hazelcast.jet.sql.impl.JetJoinInfo;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcSqlConnector;
import com.hazelcast.jet.sql.impl.connector.jdbc.TypeResolver;
import com.hazelcast.jet.sql.impl.connector.jdbc.join.JoinPredicateProcessingResult;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.JetSqlRow;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

public class JoinPredicateScanRowMapper
implements Function<ResultSet, JetSqlRow> {
    private final ExpressionEvalContext expressionEvalContext;
    private TypeResolver typeResolver;
    private List<FunctionEx<Object, ?>> converters;
    private final JetJoinInfo joinInfo;
    private final List<Expression<?>> projections;
    private final List<JetSqlRow> leftRowsList;
    private Object[] values;
    private int queryNumberColumnIndex;
    private int leftRowIndex;
    private boolean moveResultSetForward = true;
    private boolean hasNext;
    private final Set<Integer> processedQueryNumbers = new HashSet<Integer>();
    private BiFunctionEx<ResultSet, Integer, ?>[] valueGetters;

    public JoinPredicateScanRowMapper(ExpressionEvalContext expressionEvalContext, TypeResolver typeResolver, List<FunctionEx<Object, ?>> converters, List<Expression<?>> projections, JetJoinInfo joinInfo, List<JetSqlRow> leftRowsList) {
        this.expressionEvalContext = expressionEvalContext;
        this.typeResolver = typeResolver;
        this.converters = converters;
        this.projections = projections;
        this.joinInfo = joinInfo;
        this.leftRowsList = leftRowsList;
    }

    private JoinPredicateProcessingResult processResultSet(ResultSet resultSet) throws SQLException {
        JoinPredicateProcessingResult joinPredicateProcessingResult = new JoinPredicateProcessingResult();
        if (this.moveResultSetForward) {
            this.hasNext = resultSet.next();
        }
        if (this.hasNext) {
            this.fillValueArray(resultSet);
            int queryNumberFromResultSet = resultSet.getInt(this.queryNumberColumnIndex);
            if (this.leftRowIndex != queryNumberFromResultSet) {
                this.moveResultSetForward = false;
                joinPredicateProcessingResult.jetSqlRow = this.processMismatchingQueryNumber();
                ++this.leftRowIndex;
            } else {
                this.moveResultSetForward = true;
                joinPredicateProcessingResult.jetSqlRow = this.processMatchingQueryNumber();
            }
            joinPredicateProcessingResult.isResultSetProcessed = true;
        }
        return joinPredicateProcessingResult;
    }

    @Override
    public JetSqlRow apply(ResultSet resultSet) {
        try {
            this.createValuesArrayIfNecessary(resultSet);
            while (this.leftRowIndex < this.leftRowsList.size()) {
                JoinPredicateProcessingResult joinPredicateProcessingResult = this.processResultSet(resultSet);
                if (joinPredicateProcessingResult.isResultSetProcessed) {
                    if (joinPredicateProcessingResult.jetSqlRow == null) continue;
                    return joinPredicateProcessingResult.jetSqlRow;
                }
                JetSqlRow jetSqlRow = this.processMismatchingQueryNumber();
                ++this.leftRowIndex;
                if (jetSqlRow == null) continue;
                return jetSqlRow;
            }
            return null;
        }
        catch (Exception e) {
            throw ExceptionUtil.sneakyThrow((Throwable)e);
        }
    }

    private void createValuesArrayIfNecessary(ResultSet resultSet) throws SQLException {
        if (this.values == null) {
            this.values = this.createValueArrayExcludingQueryNumber(resultSet);
            this.queryNumberColumnIndex = this.getQueryNumberColumnIndex(resultSet);
        }
    }

    protected JetSqlRow createExtendedRowIfNecessary(JetSqlRow leftRow) {
        JetSqlRow result = null;
        if (!this.joinInfo.isInner()) {
            result = leftRow.extendedRow(this.projections.size());
        }
        return result;
    }

    protected Object[] createValueArrayExcludingQueryNumber(ResultSet resultSet) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        int columnCount = metaData.getColumnCount();
        return new Object[columnCount - 1];
    }

    protected int getQueryNumberColumnIndex(ResultSet resultSet) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        return metaData.getColumnCount();
    }

    protected void fillValueArray(ResultSet resultSet) throws SQLException {
        if (this.valueGetters == null) {
            this.valueGetters = JdbcSqlConnector.prepareValueGettersFromMetadata(this.typeResolver, resultSet, this.converters::get);
        }
        for (int index = 0; index < this.values.length; ++index) {
            this.values[index] = this.valueGetters[index].apply((Object)resultSet, (Object)(index + 1));
        }
    }

    private JetSqlRow processMismatchingQueryNumber() {
        JetSqlRow result = null;
        JetSqlRow leftRow = this.leftRowsList.get(this.leftRowIndex);
        if (!this.processedQueryNumbers.contains(this.leftRowIndex)) {
            result = this.createExtendedRowIfNecessary(leftRow);
            this.processedQueryNumbers.add(this.leftRowIndex);
        }
        return result;
    }

    private JetSqlRow processMatchingQueryNumber() {
        JetSqlRow jetSqlRowFromDB;
        JetSqlRow leftRow = this.leftRowsList.get(this.leftRowIndex);
        JetSqlRow joinedRow = ExpressionUtil.join(leftRow, jetSqlRowFromDB = new JetSqlRow((SerializationService)this.expressionEvalContext.getSerializationService(), this.values), this.joinInfo.nonEquiCondition(), this.expressionEvalContext);
        JetSqlRow result = joinedRow != null ? joinedRow : this.createExtendedRowIfNecessary(leftRow);
        this.processedQueryNumbers.add(this.leftRowIndex);
        return result;
    }
}

