/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.file;

import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataAvroResolver;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.avro.Schema;

public final class AvroResolver {
    private AvroResolver() {
    }

    static List<MappingField> resolveFields(Schema schema) {
        LinkedHashMap<String, MappingField> fields = new LinkedHashMap<String, MappingField>();
        for (Schema.Field schemaField : schema.getFields()) {
            String name = schemaField.name();
            Schema.Type schemaFieldType = AvroResolver.unwrapNullableType(schemaField.schema()).getType();
            QueryDataType type = KvMetadataAvroResolver.Schemas.AVRO_TO_SQL.getOrDefault(schemaFieldType, QueryDataType.OBJECT);
            MappingField field = new MappingField(name, type);
            fields.putIfAbsent(field.name(), field);
        }
        return new ArrayList<MappingField>(fields.values());
    }

    public static Schema unwrapNullableType(Schema schema) {
        List unionSchemas;
        if (schema.isUnion() && (unionSchemas = schema.getTypes()).size() == 2) {
            if (((Schema)unionSchemas.get(0)).getType() == Schema.Type.NULL) {
                return (Schema)unionSchemas.get(1);
            }
            if (((Schema)unionSchemas.get(1)).getType() == Schema.Type.NULL) {
                return (Schema)unionSchemas.get(0);
            }
        }
        return schema;
    }
}

