/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.connection.pgproto;

import io.debezium.connector.postgresql.PostgresStreamingChangeEventSource;
import io.debezium.connector.postgresql.PostgresType;
import io.debezium.connector.postgresql.PostgresValueConverter;
import io.debezium.connector.postgresql.TypeRegistry;
import io.debezium.connector.postgresql.connection.AbstractColumnValue;
import io.debezium.connector.postgresql.connection.DateTimeFormat;
import io.debezium.connector.postgresql.proto.PgProto;
import io.debezium.data.SpecialValueDecimal;
import io.debezium.time.Conversions;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import org.postgresql.geometric.PGpoint;
import org.postgresql.jdbc.PgArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgProtoColumnValue
extends AbstractColumnValue<PgProto.DatumMessage> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PgProtoColumnValue.class);
    private static final long TIMESTAMP_MIN = -211813488000000000L;
    private static final long TIMESTAMP_MAX = 9223371331200000000L;
    private PgProto.DatumMessage value;

    public PgProtoColumnValue(PgProto.DatumMessage value) {
        this.value = value;
    }

    @Override
    public PgProto.DatumMessage getRawValue() {
        return this.value;
    }

    @Override
    public boolean isNull() {
        return this.value.hasDatumMissing();
    }

    @Override
    public String asString() {
        if (this.value.hasDatumString()) {
            return this.value.getDatumString();
        }
        if (this.value.hasDatumBytes()) {
            return new String(this.asByteArray(), Charset.forName("UTF-8"));
        }
        return null;
    }

    @Override
    public Boolean asBoolean() {
        if (this.value.hasDatumBool()) {
            return this.value.getDatumBool();
        }
        String s2 = this.asString();
        if (s2 != null) {
            if (s2.equalsIgnoreCase("t")) {
                return Boolean.TRUE;
            }
            if (s2.equalsIgnoreCase("f")) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    @Override
    public Integer asInteger() {
        if (this.value.hasDatumInt32()) {
            return this.value.getDatumInt32();
        }
        String s2 = this.asString();
        return s2 != null ? Integer.valueOf(s2) : null;
    }

    @Override
    public Long asLong() {
        if (this.value.hasDatumInt64()) {
            return this.value.getDatumInt64();
        }
        String s2 = this.asString();
        return s2 != null ? Long.valueOf(s2) : null;
    }

    @Override
    public Float asFloat() {
        if (this.value.hasDatumFloat()) {
            return Float.valueOf(this.value.getDatumFloat());
        }
        String s2 = this.asString();
        return s2 != null ? Float.valueOf(s2) : null;
    }

    @Override
    public Double asDouble() {
        if (this.value.hasDatumDouble()) {
            return this.value.getDatumDouble();
        }
        String s2 = this.asString();
        return s2 != null ? Double.valueOf(s2) : null;
    }

    @Override
    public Object asDecimal() {
        if (this.value.hasDatumDouble()) {
            return this.value.getDatumDouble();
        }
        String s2 = this.asString();
        if (s2 != null) {
            return PostgresValueConverter.toSpecialValue(s2).orElseGet(() -> new SpecialValueDecimal(new BigDecimal(s2)));
        }
        return null;
    }

    @Override
    public byte[] asByteArray() {
        return this.value.hasDatumBytes() ? this.value.getDatumBytes().toByteArray() : null;
    }

    @Override
    public LocalDate asLocalDate() {
        if (this.value.hasDatumInt32()) {
            return LocalDate.ofEpochDay(this.value.getDatumInt32());
        }
        String s2 = this.asString();
        return s2 != null ? DateTimeFormat.get().date(s2) : null;
    }

    @Override
    public Object asTime() {
        if (this.value.hasDatumInt64()) {
            return Duration.of(this.value.getDatumInt64(), ChronoUnit.MICROS);
        }
        String s2 = this.asString();
        if (s2 != null) {
            return DateTimeFormat.get().time(s2);
        }
        return null;
    }

    @Override
    public OffsetTime asOffsetTimeUtc() {
        if (this.value.hasDatumDouble()) {
            return Conversions.toInstantFromMicros((long)((long)this.value.getDatumDouble())).atOffset(ZoneOffset.UTC).toOffsetTime();
        }
        String s2 = this.asString();
        return s2 != null ? DateTimeFormat.get().timeWithTimeZone(s2) : null;
    }

    @Override
    public OffsetDateTime asOffsetDateTimeAtUtc() {
        if (this.value.hasDatumInt64()) {
            if (this.value.getDatumInt64() >= 9223371331200000000L) {
                LOGGER.trace("Infinite(+) value '{}' arrived from database", (Object)this.value.getDatumInt64());
                return PostgresValueConverter.POSITIVE_INFINITY_OFFSET_DATE_TIME;
            }
            if (this.value.getDatumInt64() < -211813488000000000L) {
                LOGGER.trace("Infinite(-) value '{}' arrived from database", (Object)this.value.getDatumInt64());
                return PostgresValueConverter.NEGATIVE_INFINITY_OFFSET_DATE_TIME;
            }
            return Conversions.toInstantFromMicros((long)this.value.getDatumInt64()).atOffset(ZoneOffset.UTC);
        }
        String s2 = this.asString();
        return s2 != null ? DateTimeFormat.get().timestampWithTimeZoneToOffsetDateTime(s2).withOffsetSameInstant(ZoneOffset.UTC) : null;
    }

    @Override
    public Instant asInstant() {
        if (this.value.hasDatumInt64()) {
            if (this.value.getDatumInt64() >= 9223371331200000000L) {
                LOGGER.trace("Infinite(+) value '{}' arrived from database", (Object)this.value.getDatumInt64());
                return PostgresValueConverter.POSITIVE_INFINITY_INSTANT;
            }
            if (this.value.getDatumInt64() < -211813488000000000L) {
                LOGGER.trace("Infinite(-) value '{}' arrived from database", (Object)this.value.getDatumInt64());
                return PostgresValueConverter.NEGATIVE_INFINITY_INSTANT;
            }
            return Conversions.toInstantFromMicros((long)this.value.getDatumInt64());
        }
        String s2 = this.asString();
        return s2 != null ? DateTimeFormat.get().timestampToInstant(this.asString()) : null;
    }

    @Override
    public Object asLocalTime() {
        return this.asTime();
    }

    @Override
    public Object asInterval() {
        if (this.value.hasDatumDouble()) {
            return this.value.getDatumDouble();
        }
        String s2 = this.asString();
        return s2 != null ? super.asInterval() : null;
    }

    @Override
    public BigDecimal asMoney() {
        if (this.value.hasDatumInt64()) {
            return new BigDecimal(this.value.getDatumInt64()).divide(new BigDecimal(100.0));
        }
        return super.asMoney();
    }

    @Override
    public PGpoint asPoint() {
        if (this.value.hasDatumPoint()) {
            PgProto.Point datumPoint = this.value.getDatumPoint();
            return new PGpoint(datumPoint.getX(), datumPoint.getY());
        }
        if (this.value.hasDatumBytes()) {
            return super.asPoint();
        }
        return null;
    }

    @Override
    public boolean isArray(PostgresType type) {
        int oidValue = type.getOid();
        switch (oidValue) {
            case 143: 
            case 199: 
            case 651: 
            case 775: 
            case 791: 
            case 1000: 
            case 1001: 
            case 1002: 
            case 1003: 
            case 1005: 
            case 1007: 
            case 1009: 
            case 1014: 
            case 1015: 
            case 1016: 
            case 1017: 
            case 1021: 
            case 1022: 
            case 1028: 
            case 1040: 
            case 1041: 
            case 1115: 
            case 1182: 
            case 1183: 
            case 1185: 
            case 1187: 
            case 1231: 
            case 1270: 
            case 1563: 
            case 2201: 
            case 2951: 
            case 3807: 
            case 3905: 
            case 3907: 
            case 3909: 
            case 3911: 
            case 3913: 
            case 3927: {
                return true;
            }
        }
        return type.isArrayType();
    }

    @Override
    public Object asArray(String columnName, PostgresType type, String fullType, PostgresStreamingChangeEventSource.PgConnectionSupplier connection) {
        try {
            byte[] data = this.asByteArray();
            if (data == null) {
                return null;
            }
            String dataString = new String(data, Charset.forName("UTF-8"));
            PgArray arrayData = new PgArray(connection.get(), (int)this.value.getColumnType(), dataString);
            Object deserializedArray = arrayData.getArray();
            return Arrays.asList((Object[])deserializedArray);
        }
        catch (SQLException e) {
            LOGGER.warn("Unexpected exception trying to process PgArray column '{}'", (Object)this.value.getColumnName(), (Object)e);
            return null;
        }
    }

    @Override
    public Object asDefault(TypeRegistry typeRegistry, int columnType, String columnName, String fullType, boolean includeUnknownDatatypes, PostgresStreamingChangeEventSource.PgConnectionSupplier connection) {
        PostgresType type = typeRegistry.get(columnType);
        if (type.getOid() == typeRegistry.geometryOid() || type.getOid() == typeRegistry.geographyOid() || type.getOid() == typeRegistry.citextOid() || type.getOid() == typeRegistry.hstoreOid()) {
            return this.asByteArray();
        }
        if (includeUnknownDatatypes) {
            return this.asByteArray();
        }
        return null;
    }
}

