/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.connection;

public class ReplicaIdentityInfo {
    private String indexName;
    private final ReplicaIdentity replicaIdentity;

    public ReplicaIdentityInfo(ReplicaIdentity replicaIdentity) {
        this.replicaIdentity = replicaIdentity;
        this.indexName = null;
    }

    public ReplicaIdentityInfo(ReplicaIdentity replicaIdentity, String indexName) {
        this(replicaIdentity);
        this.indexName = indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public String description() {
        return this.replicaIdentity.description();
    }

    public ReplicaIdentity getReplicaIdentity() {
        return this.replicaIdentity;
    }

    public String toString() {
        return this.indexName != null ? String.format("USING INDEX %s", this.indexName) : this.replicaIdentity.name();
    }

    public static enum ReplicaIdentity {
        NOTHING("UPDATE and DELETE events will not contain any old values"),
        FULL("UPDATE AND DELETE events will contain the previous values of all the columns"),
        DEFAULT("UPDATE and DELETE events will contain previous values only for PK columns"),
        INDEX("UPDATE and DELETE events will contain previous values only for columns present in the REPLICA IDENTITY index"),
        UNKNOWN("Unknown REPLICA IDENTITY");

        private final String description;

        public String description() {
            return this.description;
        }

        private ReplicaIdentity(String description) {
            this.description = description;
        }

        static ReplicaIdentity parseFromDB(String s2) {
            switch (s2) {
                case "n": {
                    return NOTHING;
                }
                case "d": {
                    return DEFAULT;
                }
                case "i": {
                    return INDEX;
                }
                case "f": {
                    return FULL;
                }
            }
            return UNKNOWN;
        }
    }
}

