/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.jet.cdc.postgres;

import com.hazelcast.enterprise.jet.cdc.ChangeRecord;
import com.hazelcast.enterprise.jet.cdc.DebeziumCdcSources;
import com.hazelcast.enterprise.jet.cdc.DebeziumSnapshotMode;
import com.hazelcast.enterprise.jet.cdc.RecordMappingFunction;
import com.hazelcast.enterprise.jet.cdc.SequenceExtractor;
import com.hazelcast.enterprise.jet.cdc.impl.ChangeRecordMappingFn;
import com.hazelcast.enterprise.jet.cdc.impl.PropertyRules;
import com.hazelcast.enterprise.jet.cdc.postgres.PostgresSequenceExtractor;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.pipeline.StreamSource;
import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.spi.snapshot.Snapshotter;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nonnull;

public final class PostgresCdcSources {
    private PostgresCdcSources() {
    }

    @Nonnull
    public static Builder<ChangeRecord> postgres(@Nonnull String name) {
        return new Builder<ChangeRecord>(name);
    }

    public static final class Builder<T>
    extends DebeziumCdcSources.Builder<T> {
        private static final PropertyRules RULES = new PropertyRules().required("database.hostname").required("database.user").required("database.password").required("database.dbname").inclusive("database.sslkey", "database.sslpassword").exclusive("schema.include.list", "schema.exclude.list").exclusive("table.include.list", "table.exclude.list");

        private Builder(@Nonnull String name) {
            super(name, "io.debezium.connector.postgresql.PostgresConnector", (RecordMappingFunction)new ChangeRecordMappingFn());
            Objects.requireNonNull(name, "name cannot be null");
        }

        @Nonnull
        public Builder<T> setSnapshotMode(@Nonnull DebeziumSnapshotMode snapshotMode) {
            PostgresConnectorConfig.SnapshotMode debeziumMode = switch (snapshotMode) {
                default -> throw new IncompatibleClassChangeError();
                case DebeziumSnapshotMode.ALWAYS -> PostgresConnectorConfig.SnapshotMode.ALWAYS;
                case DebeziumSnapshotMode.INITIAL -> PostgresConnectorConfig.SnapshotMode.INITIAL;
                case DebeziumSnapshotMode.INITIAL_ONLY -> PostgresConnectorConfig.SnapshotMode.INITIAL_ONLY;
                case DebeziumSnapshotMode.NO_DATA -> PostgresConnectorConfig.SnapshotMode.NO_DATA;
                case DebeziumSnapshotMode.CONFIGURATION_BASED -> PostgresConnectorConfig.SnapshotMode.CONFIGURATION_BASED;
                case DebeziumSnapshotMode.WHEN_NEEDED -> PostgresConnectorConfig.SnapshotMode.WHEN_NEEDED;
            };
            this.config.setProperty("snapshot.mode", debeziumMode.getValue());
            return this;
        }

        @Nonnull
        public Builder<T> setCustomSnapshotter(@Nonnull Class<?> snapshotterClass) {
            Preconditions.checkState((boolean)Snapshotter.class.isAssignableFrom(snapshotterClass), (String)"snapshotterClass must be a subclass of Snapshotter");
            this.config.setProperty("snapshot.mode", PostgresConnectorConfig.SnapshotMode.CUSTOM.getValue());
            try {
                Snapshotter instance = (Snapshotter)ClassLoaderUtil.newInstance((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), snapshotterClass);
                this.config.setProperty("snapshot.custom.class", instance.name());
            }
            catch (Exception e) {
                throw new JetException("Cannot construct an instance of Snapshotter " + String.valueOf(snapshotterClass), (Throwable)e);
            }
            return this;
        }

        @Nonnull
        public Builder<T> setDatabaseAddress(@Nonnull String address, int port) {
            this.config.setProperty("database.hostname", address);
            this.config.setProperty("database.port", Integer.toString(port));
            return this;
        }

        public Builder<T> setDatabaseCredentials(@Nonnull String user, @Nonnull String password) {
            this.config.setProperty("database.user", user);
            this.config.setProperty("database.password", password);
            return this;
        }

        @Nonnull
        public Builder<T> setDatabaseAddress(@Nonnull String address) {
            this.config.setProperty("database.hostname", address);
            return this;
        }

        @Nonnull
        public Builder<T> setDatabasePort(int port) {
            this.config.setProperty("database.port", Integer.toString(port));
            return this;
        }

        @Nonnull
        public Builder<T> setDatabaseUser(@Nonnull String user) {
            this.config.setProperty("database.user", user);
            return this;
        }

        @Nonnull
        public Builder<T> setDatabasePassword(@Nonnull String password) {
            this.config.setProperty("database.password", password);
            return this;
        }

        @Nonnull
        public Builder<T> setDatabaseName(@Nonnull String dbName) {
            this.config.setProperty("database.dbname", dbName);
            return this;
        }

        @Nonnull
        public Builder<T> setSchemaIncludeList(String ... schemaNameRegExps) {
            this.config.setProperty("schema.include.list", (Object)schemaNameRegExps);
            return this;
        }

        @Nonnull
        public Builder<T> setSchemaExcludeList(String ... schemaNameRegExps) {
            this.config.setProperty("schema.exclude.list", (Object)schemaNameRegExps);
            return this;
        }

        @Nonnull
        public Builder<T> setDatabaseIncludeList(String ... databaseNameRegExps) {
            return (Builder)super.setDatabaseIncludeList(databaseNameRegExps);
        }

        @Nonnull
        public Builder<T> setDatabaseExcludeList(String ... databaseNameRegExps) {
            return (Builder)super.setDatabaseExcludeList(databaseNameRegExps);
        }

        @Nonnull
        public Builder<T> setTableIncludeList(String ... tableNameRegExps) {
            this.config.setProperty("table.include.list", String.join((CharSequence)",", tableNameRegExps));
            return this;
        }

        @Nonnull
        public Builder<T> setTableExcludeList(String ... tableNameRegExps) {
            this.config.setProperty("table.exclude.list", (Object)tableNameRegExps);
            return this;
        }

        @Nonnull
        public Builder<T> setColumnIncludeList(String ... columnNameRegExps) {
            this.config.setProperty("column.include.list", (Object)columnNameRegExps);
            return this;
        }

        @Nonnull
        public Builder<T> setLogicalDecodingPlugIn(@Nonnull String pluginName) {
            this.config.setProperty("plugin.name", pluginName);
            return this;
        }

        @Nonnull
        public Builder<T> setReplicationSlotName(@Nonnull String slotName) {
            this.config.setProperty("slot.name", slotName);
            return this;
        }

        @Nonnull
        public Builder<T> setReplicationSlotDropOnStop(boolean dropOnStop) {
            this.config.setProperty("slot.drop.on.stop", (Object)dropOnStop);
            return this;
        }

        @Nonnull
        public Builder<T> setPublicationName(@Nonnull String publicationName) {
            this.config.setProperty("publication.name", publicationName);
            return this;
        }

        @Nonnull
        public Builder<T> setSslMode(@Nonnull String mode) {
            this.config.setProperty("database.sslmode", mode);
            return this;
        }

        @Nonnull
        public Builder<T> setSslCertificateFile(@Nonnull String file) {
            this.config.setProperty("database.sslcert", file);
            return this;
        }

        @Nonnull
        public Builder<T> setSslKeyFile(@Nonnull String file) {
            this.config.setProperty("database.sslkey", file);
            return this;
        }

        @Nonnull
        public Builder<T> setSslKeyFilePassword(@Nonnull String password) {
            this.config.setProperty("database.sslpassword", password);
            return this;
        }

        @Nonnull
        public Builder<T> setSslRootCertificateFile(@Nonnull String file) {
            this.config.setProperty("database.sslrootcert", file);
            return this;
        }

        @Nonnull
        public Builder<ChangeRecord> changeRecord() {
            return (Builder)super.changeRecord();
        }

        @Nonnull
        public Builder<Map.Entry<String, String>> json() {
            return (Builder)super.json();
        }

        @Nonnull
        public <T_NEW> Builder<T_NEW> customMapping(@Nonnull RecordMappingFunction<T_NEW> recordMappingFunction) {
            return (Builder)super.customMapping(recordMappingFunction);
        }

        @Nonnull
        public Builder<T> withSequenceExtractor(Class<? extends SequenceExtractor> sequenceExtractorClass) {
            return (Builder)super.withSequenceExtractor(sequenceExtractorClass);
        }

        @Nonnull
        public Builder<T> withDefaultEngine() {
            return (Builder)super.withDefaultEngine();
        }

        @Nonnull
        public Builder<T> withAsyncEngine() {
            return (Builder)super.withAsyncEngine();
        }

        @Nonnull
        public Builder<T> withErrorMaxRetries(int errorRetryCount) {
            return (Builder)super.withErrorMaxRetries(errorRetryCount);
        }

        @Nonnull
        public Builder<T> setProperty(@Nonnull String key, @Nonnull String value) {
            return (Builder)super.setProperty(key, value);
        }

        @Nonnull
        public Builder<T> setProperty(@Nonnull String key, long value) {
            return (Builder)super.setProperty(key, value);
        }

        @Nonnull
        public Builder<T> setProperty(@Nonnull String key, boolean value) {
            return (Builder)super.setProperty(key, value);
        }

        @Nonnull
        public Builder<T> setProperty(@Nonnull String key, int value) {
            return (Builder)super.setProperty(key, value);
        }

        @Nonnull
        public StreamSource<T> build() {
            this.config.setProperty("sequence.extractor.class", PostgresSequenceExtractor.class.getName());
            Properties properties = this.config.toProperties();
            RULES.check(properties);
            return super.build();
        }
    }
}

