/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.kafka.connect;

import com.hazelcast.client.impl.protocol.util.PropertiesUtil;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.kafka.connect.impl.ReadKafkaConnectP;
import com.hazelcast.jet.kafka.connect.impl.SourceConnectorWrapper;
import com.hazelcast.jet.kafka.connect.impl.processorsupplier.ReadKafkaConnectProcessorSupplier;
import com.hazelcast.jet.kafka.connect.impl.processorsupplier.TaskMaxProcessorMetaSupplier;
import com.hazelcast.jet.pipeline.Sources;
import com.hazelcast.jet.pipeline.StreamSource;
import com.hazelcast.jet.retry.RetryStrategy;
import java.io.Serializable;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.kafka.connect.source.SourceRecord;

public final class KafkaConnectSources {
    private KafkaConnectSources() {
    }

    @Nonnull
    public static <T> StreamSource<T> connect(@Nonnull Properties properties, @Nonnull FunctionEx<SourceRecord, T> projectionFn) {
        return KafkaConnectSources.connect(properties, projectionFn, SourceConnectorWrapper.DEFAULT_RECONNECT_BEHAVIOR);
    }

    @Nonnull
    public static <T> StreamSource<T> connect(@Nonnull Properties properties, @Nonnull FunctionEx<SourceRecord, T> projectionFn, @Nullable RetryStrategy retryStrategy) {
        Objects.requireNonNull(properties, "properties is required");
        Objects.requireNonNull(projectionFn, "projectionFn is required");
        SerializationUtil.checkSerializable(projectionFn, (String)"projectionFn");
        if (retryStrategy != null) {
            SerializationUtil.checkSerializable((Object)retryStrategy, (String)"retryStrategy");
        }
        Preconditions.checkRequiredProperty((Properties)properties, (String)"name");
        Preconditions.checkRequiredProperty((Properties)properties, (String)"connector.class");
        Properties defaultProperties = KafkaConnectSources.getDefaultProperties(properties);
        String strTasksMax = defaultProperties.getProperty("tasks.max");
        int tasksMax = Integer.parseInt(strTasksMax);
        Preconditions.checkPositive((double)tasksMax, (String)"tasks.max must be positive");
        TaskMaxProcessorMetaSupplier metaSupplier = new TaskMaxProcessorMetaSupplier();
        metaSupplier.setTasksMax(tasksMax);
        String name = "kafkaConnectSource(" + defaultProperties.getProperty("name") + ")";
        return Sources.streamFromProcessorWithWatermarks((String)name, (boolean)true, (FunctionEx & Serializable)eventTimePolicy -> {
            ReadKafkaConnectProcessorSupplier sup = ReadKafkaConnectP.processorSupplier(defaultProperties, eventTimePolicy, projectionFn, retryStrategy);
            metaSupplier.setSupplier(sup);
            return metaSupplier;
        });
    }

    @Nonnull
    public static StreamSource<SourceRecord> connect(@Nonnull Properties properties) {
        return KafkaConnectSources.connect(properties, FunctionEx.identity());
    }

    private static Properties getDefaultProperties(Properties properties) {
        Properties defaultProperties = PropertiesUtil.clone((Properties)properties);
        defaultProperties.putIfAbsent("tasks.max", "1");
        return defaultProperties;
    }
}

