/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.com.amazonaws.services.kinesis.model.transform;

import com.hazelcast.shaded.com.amazonaws.services.kinesis.model.Record;
import com.hazelcast.shaded.com.amazonaws.transform.JsonUnmarshallerContext;
import com.hazelcast.shaded.com.amazonaws.transform.Unmarshaller;
import com.hazelcast.shaded.com.fasterxml.jackson.core.JsonToken;
import java.nio.ByteBuffer;
import java.util.Date;

public class RecordJsonUnmarshaller
implements Unmarshaller<Record, JsonUnmarshallerContext> {
    private static RecordJsonUnmarshaller instance;

    @Override
    public Record unmarshall(JsonUnmarshallerContext context) throws Exception {
        Record record = new Record();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("SequenceNumber", targetDepth)) {
                    context.nextToken();
                    record.setSequenceNumber(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ApproximateArrivalTimestamp", targetDepth)) {
                    context.nextToken();
                    record.setApproximateArrivalTimestamp(context.getUnmarshaller(Date.class).unmarshall(context));
                }
                if (context.testExpression("Data", targetDepth)) {
                    context.nextToken();
                    record.setData(context.getUnmarshaller(ByteBuffer.class).unmarshall(context));
                }
                if (context.testExpression("PartitionKey", targetDepth)) {
                    context.nextToken();
                    record.setPartitionKey(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("EncryptionType", targetDepth)) {
                    context.nextToken();
                    record.setEncryptionType(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return record;
    }

    public static RecordJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new RecordJsonUnmarshaller();
        }
        return instance;
    }
}

