/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.com.amazonaws.auth;

import com.hazelcast.shaded.com.amazonaws.SdkClientException;
import com.hazelcast.shaded.com.amazonaws.auth.AWSCredentials;
import com.hazelcast.shaded.com.amazonaws.auth.AWSCredentialsProvider;
import com.hazelcast.shaded.com.amazonaws.auth.ContainerCredentialsFetcher;
import com.hazelcast.shaded.com.amazonaws.auth.ContainerCredentialsRetryPolicy;
import com.hazelcast.shaded.com.amazonaws.internal.CredentialsEndpointProvider;
import com.hazelcast.shaded.com.amazonaws.retry.internal.CredentialsEndpointRetryPolicy;
import com.hazelcast.shaded.com.amazonaws.util.StringUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ContainerCredentialsProvider
implements AWSCredentialsProvider {
    static final String ECS_CONTAINER_CREDENTIALS_PATH = "AWS_CONTAINER_CREDENTIALS_RELATIVE_URI";
    static final String CONTAINER_CREDENTIALS_FULL_URI = "AWS_CONTAINER_CREDENTIALS_FULL_URI";
    static final String AWS_EC2_METADATA_SERVICE_ENDPOINT_MODE = "AWS_EC2_METADATA_SERVICE_ENDPOINT_MODE";
    static final String CONTAINER_AUTHORIZATION_TOKEN = "AWS_CONTAINER_AUTHORIZATION_TOKEN";
    static final String CONTAINER_AUTHORIZATION_TOKEN_FILE = "AWS_CONTAINER_AUTHORIZATION_TOKEN_FILE";
    private static final String HTTPS = "https";
    private static final String ECS_CREDENTIALS_ENDPOINT = "http://169.254.170.2";
    private static final String ECS_CONTAINER_HOST = "169.254.170.2";
    private static final String EKS_CONTAINER_HOST = "169.254.170.23";
    private static final String EKS_CONTAINER_HOST_IPV6 = "[fd00:ec2::23]";
    private static final List<String> VALID_LOOP_BACK_IPV4 = Arrays.asList("169.254.170.2", "169.254.170.23");
    private static final List<String> VALID_LOOP_BACK_IPV6 = Arrays.asList("[fd00:ec2::23]");
    private final ContainerCredentialsFetcher credentialsFetcher;

    @Deprecated
    public ContainerCredentialsProvider() {
        this(new ECSCredentialsEndpointProvider());
    }

    public ContainerCredentialsProvider(CredentialsEndpointProvider credentialsEndpointProvider) {
        this.credentialsFetcher = new ContainerCredentialsFetcher(credentialsEndpointProvider);
    }

    @Override
    public AWSCredentials getCredentials() {
        return this.credentialsFetcher.getCredentials();
    }

    @Override
    public void refresh() {
        this.credentialsFetcher.refresh();
    }

    public Date getCredentialsExpiration() {
        return this.credentialsFetcher.getCredentialsExpiration();
    }

    static class FullUriCredentialsEndpointProvider
    extends CredentialsEndpointProvider {
        FullUriCredentialsEndpointProvider() {
        }

        @Override
        public URI getCredentialsEndpoint() {
            String fullUri = System.getenv(ContainerCredentialsProvider.CONTAINER_CREDENTIALS_FULL_URI);
            if (fullUri == null || fullUri.length() == 0) {
                throw new SdkClientException("The environment variable AWS_CONTAINER_CREDENTIALS_FULL_URI is empty");
            }
            URI uri = URI.create(fullUri);
            if (!this.isHttps(uri) && !this.isAllowedHost(uri.getHost())) {
                throw new SdkClientException("The full URI (" + uri + ") contained withing environment variable " + ContainerCredentialsProvider.CONTAINER_CREDENTIALS_FULL_URI + " has an invalid host. Host should resolve to a loopback address or have the full URI be HTTPS.");
            }
            return uri;
        }

        @Override
        public Map<String, String> getHeaders() {
            String tokenValue = this.getTokenValue();
            if (StringUtils.isNullOrEmpty(tokenValue)) {
                return new HashMap<String, String>();
            }
            return Collections.singletonMap("Authorization", tokenValue);
        }

        private String getTokenValue() {
            if (System.getenv(ContainerCredentialsProvider.CONTAINER_AUTHORIZATION_TOKEN) != null) {
                return System.getenv(ContainerCredentialsProvider.CONTAINER_AUTHORIZATION_TOKEN);
            }
            if (System.getenv(ContainerCredentialsProvider.CONTAINER_AUTHORIZATION_TOKEN_FILE) != null) {
                String tokenFile = System.getenv(ContainerCredentialsProvider.CONTAINER_AUTHORIZATION_TOKEN_FILE);
                return this.readToken(tokenFile);
            }
            return null;
        }

        private String readToken(String tokenFile) {
            try {
                byte[] bytes = Files.readAllBytes(FileSystems.getDefault().getPath(tokenFile, new String[0]));
                return new String(bytes, StringUtils.UTF8);
            }
            catch (IOException e) {
                throw new SdkClientException(String.format("Cannot fetch credentials from container - failed to read %s", tokenFile));
            }
        }

        private boolean isHttps(URI endpoint) {
            return Objects.equals(ContainerCredentialsProvider.HTTPS, endpoint.getScheme());
        }

        private boolean isAllowedHost(String host) {
            try {
                InetAddress[] addresses = InetAddress.getAllByName(host);
                boolean allAllowed = true;
                for (InetAddress address : addresses) {
                    if (this.isLoopbackAddress(address)) continue;
                    allAllowed = false;
                }
                return addresses.length > 0 && (allAllowed || this.isMetadataServiceEndpoint(host));
            }
            catch (UnknownHostException e) {
                throw new SdkClientException(String.format("host (%s) could not be resolved to an IP address.", host), e);
            }
        }

        private boolean isLoopbackAddress(InetAddress inetAddress) {
            return inetAddress.isLoopbackAddress();
        }

        private boolean isMetadataServiceEndpoint(String host) {
            String mode = System.getenv(ContainerCredentialsProvider.AWS_EC2_METADATA_SERVICE_ENDPOINT_MODE);
            if ("IPV6".equalsIgnoreCase(mode)) {
                return VALID_LOOP_BACK_IPV6.contains(host);
            }
            return VALID_LOOP_BACK_IPV4.contains(host);
        }

        @Override
        public CredentialsEndpointRetryPolicy getRetryPolicy() {
            return ContainerCredentialsRetryPolicy.getInstance();
        }
    }

    static class ECSCredentialsEndpointProvider
    extends CredentialsEndpointProvider {
        ECSCredentialsEndpointProvider() {
        }

        @Override
        public URI getCredentialsEndpoint() {
            String path = System.getenv(ContainerCredentialsProvider.ECS_CONTAINER_CREDENTIALS_PATH);
            if (path == null) {
                throw new SdkClientException("The environment variable AWS_CONTAINER_CREDENTIALS_RELATIVE_URI is empty");
            }
            return URI.create(ContainerCredentialsProvider.ECS_CREDENTIALS_ENDPOINT + path);
        }

        @Override
        public CredentialsEndpointRetryPolicy getRetryPolicy() {
            return ContainerCredentialsRetryPolicy.getInstance();
        }
    }
}

