/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.kinesis.impl.source;

import com.hazelcast.jet.JetException;
import com.hazelcast.jet.kinesis.impl.KinesisUtil;
import com.hazelcast.jet.kinesis.impl.source.HashRange;
import com.hazelcast.shaded.com.amazonaws.services.kinesis.model.Shard;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

class ShardTracker {
    static final long EXPIRATION_MS = TimeUnit.MINUTES.toMillis(10L);
    private final Map<String, TrackingInfo> info = new HashMap<String, TrackingInfo>();
    private final HashRange[] rangePartitions;

    ShardTracker(HashRange[] rangePartitions) {
        this.rangePartitions = rangePartitions;
    }

    public void addUndetected(String shardId, BigInteger startingHashKey, long currentTimeMs) {
        assert (!this.info.containsKey(shardId));
        this.info.put(shardId, new TrackingInfo(this.findOwner(startingHashKey), currentTimeMs));
    }

    public Map<Shard, Integer> markDetections(Set<Shard> shards, long currentTimeMs) {
        Map<Shard, Integer> newShards = Collections.emptyMap();
        for (Shard shard : shards) {
            boolean firstDetection;
            String shardId = shard.getShardId();
            TrackingInfo trackingInfo = this.info.get(shardId);
            if (trackingInfo == null) {
                int owner = this.findOwner(new BigInteger(shard.getHashKeyRange().getStartingHashKey()));
                trackingInfo = new TrackingInfo(owner, currentTimeMs);
                this.info.put(shardId, trackingInfo);
            }
            if (!(firstDetection = trackingInfo.markDetection(currentTimeMs))) continue;
            if (newShards.isEmpty()) {
                newShards = new HashMap<Shard, Integer>();
            }
            newShards.put(shard, trackingInfo.getOwner());
        }
        return newShards;
    }

    private int findOwner(BigInteger startingHashKey) {
        for (int i = 0; i < this.rangePartitions.length; ++i) {
            HashRange range = this.rangePartitions[i];
            if (!KinesisUtil.shardBelongsToRange(startingHashKey, range)) continue;
            return i;
        }
        throw new JetException("Programming error, shard not covered by any hash range");
    }

    public Map<String, Integer> removeExpiredShards(long currentTimeMs) {
        Map<String, Integer> expiredShards = Collections.emptyMap();
        Iterator<Map.Entry<String, TrackingInfo>> it = this.info.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, TrackingInfo> e = it.next();
            TrackingInfo trackingInfo = e.getValue();
            if (!trackingInfo.isExpired(currentTimeMs)) continue;
            String shardId = e.getKey();
            int owner = trackingInfo.getOwner();
            if (expiredShards.isEmpty()) {
                expiredShards = new HashMap<String, Integer>();
            }
            expiredShards.put(shardId, owner);
            it.remove();
        }
        return expiredShards;
    }

    private static final class TrackingInfo {
        private final int owner;
        private long lastUpdateTimeMs;
        private boolean detected;

        TrackingInfo(int owner, long currentTimeMs) {
            this.owner = owner;
            this.lastUpdateTimeMs = currentTimeMs;
            this.detected = false;
        }

        boolean isExpired(long currentTimeMs) {
            return currentTimeMs - this.lastUpdateTimeMs > EXPIRATION_MS;
        }

        boolean markDetection(long currentTimeMs) {
            boolean firstDetection = !this.detected;
            this.lastUpdateTimeMs = currentTimeMs;
            this.detected = true;
            return firstDetection;
        }

        int getOwner() {
            return this.owner;
        }
    }
}

