/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.kinesis.impl.source;

import com.hazelcast.shaded.com.amazonaws.services.kinesis.model.HashKeyRange;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;
import javax.annotation.Nonnull;

public class HashRange
implements Serializable {
    public static final BigInteger MIN_VALUE = BigInteger.ZERO;
    public static final BigInteger MAX_VALUE = BigInteger.valueOf(2L).pow(128);
    public static final HashRange DOMAIN = new HashRange(MIN_VALUE, MAX_VALUE);
    private static final long serialVersionUID = 1L;
    private final BigInteger minInclusive;
    private final BigInteger maxExclusive;

    public HashRange(@Nonnull BigInteger minInclusive, @Nonnull BigInteger maxExclusive) {
        if (minInclusive.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("Partition start can't be negative");
        }
        if (maxExclusive.compareTo(BigInteger.ZERO) <= 0) {
            throw new IllegalArgumentException("Partition end can't be negative or zero");
        }
        if (maxExclusive.compareTo(minInclusive) <= 0) {
            throw new IllegalArgumentException("Partition end can't be smaller or equal to partition start");
        }
        this.minInclusive = Objects.requireNonNull(minInclusive, "minInclusive");
        this.maxExclusive = Objects.requireNonNull(maxExclusive, "maxExclusive");
    }

    public static HashRange range(@Nonnull BigInteger minInclusive, @Nonnull BigInteger maxExclusive) {
        return new HashRange(minInclusive, maxExclusive);
    }

    public static HashRange range(@Nonnull HashKeyRange hashKeyRange) {
        BigInteger startInclusive = new BigInteger(hashKeyRange.getStartingHashKey());
        BigInteger endExclusive = new BigInteger(hashKeyRange.getEndingHashKey()).add(BigInteger.ONE);
        return new HashRange(startInclusive, endExclusive);
    }

    public static HashRange range(long startInclusive, long endExclusive) {
        return new HashRange(BigInteger.valueOf(startInclusive), BigInteger.valueOf(endExclusive));
    }

    public static HashRange range(@Nonnull String startInclusive, @Nonnull String endExclusive) {
        return new HashRange(new BigInteger(startInclusive), new BigInteger(endExclusive));
    }

    public HashRange partition(int index, int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("Count must be a strictly positive value");
        }
        if (index < 0 || index >= count) {
            throw new IllegalArgumentException("Index must be between 0 and " + count);
        }
        BigInteger partitionStart = this.minInclusive.add(this.size().multiply(BigInteger.valueOf(index)).divide(BigInteger.valueOf(count)));
        BigInteger partitionEnd = this.minInclusive.add(this.size().multiply(BigInteger.valueOf(index + 1)).divide(BigInteger.valueOf(count)));
        return new HashRange(partitionStart, partitionEnd);
    }

    public BigInteger getMinInclusive() {
        return this.minInclusive;
    }

    public BigInteger getMaxExclusive() {
        return this.maxExclusive;
    }

    private BigInteger size() {
        return this.maxExclusive.subtract(this.minInclusive);
    }

    public boolean contains(BigInteger value) {
        return value.compareTo(this.minInclusive) >= 0 && value.compareTo(this.maxExclusive) < 0;
    }

    public boolean isAdjacent(HashRange other) {
        return this.minInclusive.equals(other.maxExclusive) || this.maxExclusive.equals(other.minInclusive);
    }

    public int hashCode() {
        return this.minInclusive.hashCode() + 31 * this.maxExclusive.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HashRange range = (HashRange)obj;
        return this.minInclusive.equals(range.minInclusive) && this.maxExclusive.equals(range.maxExclusive);
    }

    public String toString() {
        return "HashRange[" + String.valueOf(this.minInclusive) + ", " + String.valueOf(this.maxExclusive) + ")";
    }
}

