/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.kinesis.impl.sink;

import com.hazelcast.jet.kinesis.impl.sink.SlowRecoveryDegrader;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

class SleepController {
    private static final long MINIMUM_SLEEP_MS = 100L;
    private static final long MAXIMUM_SLEEP_MS = 10000L;
    private static final int SLEEP_INCREMENT = 25;
    private static final int DEGRADATION_VS_RECOVERY_SPEED_RATIO = 10;
    private final SlowRecoveryDegrader<Long> degrader = SleepController.initSleepTracker();

    SleepController() {
    }

    long markSuccess() {
        this.degrader.ok();
        return this.degrader.output();
    }

    long markFailure() {
        this.degrader.error();
        return this.degrader.output();
    }

    private static SlowRecoveryDegrader<Long> initSleepTracker() {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(0L);
        for (long millis = 100L; millis <= 10000L; millis += 25L) {
            list.add(TimeUnit.MILLISECONDS.toNanos(millis));
        }
        return new SlowRecoveryDegrader<Long>(10, list.toArray(new Long[0]));
    }
}

