/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.kinesis.impl.sink;

import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.kinesis.impl.AbstractShardWorker;
import com.hazelcast.jet.kinesis.impl.KinesisUtil;
import com.hazelcast.jet.kinesis.impl.RandomizedRateTracker;
import com.hazelcast.jet.kinesis.impl.RetryTracker;
import com.hazelcast.jet.kinesis.impl.sink.ShardCountMonitor;
import com.hazelcast.jet.retry.RetryStrategy;
import com.hazelcast.logging.ILogger;
import com.hazelcast.shaded.com.amazonaws.SdkClientException;
import com.hazelcast.shaded.com.amazonaws.services.kinesis.AmazonKinesisAsync;
import com.hazelcast.shaded.com.amazonaws.services.kinesis.model.DescribeStreamSummaryRequest;
import com.hazelcast.shaded.com.amazonaws.services.kinesis.model.DescribeStreamSummaryResult;
import com.hazelcast.shaded.com.amazonaws.services.kinesis.model.StreamDescriptionSummary;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;

final class ShardCountMonitorImpl
extends AbstractShardWorker
implements ShardCountMonitor {
    private static final int DESCRIBE_STREAM_OPERATIONS_ALLOWED_PER_SECOND = 20;
    private static final double RATIO_OF_DESCRIBE_STREAM_RATE_UTILIZED = 0.1;
    private final AtomicInteger shardCount = new AtomicInteger();
    private final RandomizedRateTracker describeStreamRateTracker;
    private final RetryTracker describeStreamRetryTracker;
    private Future<DescribeStreamSummaryResult> describeStreamResult;
    private long nextDescribeStreamTime;

    ShardCountMonitorImpl(int knownShardCounterInstances, AmazonKinesisAsync kinesis, String streamName, RetryStrategy retryStrategy, ILogger logger) {
        super(kinesis, streamName, logger);
        this.describeStreamRetryTracker = new RetryTracker(retryStrategy);
        this.describeStreamRateTracker = ShardCountMonitorImpl.initRandomizedTracker(knownShardCounterInstances);
        this.nextDescribeStreamTime = System.nanoTime();
    }

    @Override
    public void run() {
        if (this.describeStreamResult == null) {
            this.initDescribeStream();
        } else {
            this.checkForStreamDescription();
        }
    }

    public AtomicInteger getSharedShardCounter() {
        return this.shardCount;
    }

    @Override
    public int shardCount() {
        return this.shardCount.get();
    }

    private void initDescribeStream() {
        long currentTime = System.nanoTime();
        if (currentTime < this.nextDescribeStreamTime) {
            return;
        }
        this.describeStreamResult = this.describeStreamSummaryAsync();
        this.nextDescribeStreamTime = currentTime + this.describeStreamRateTracker.next();
    }

    private Future<DescribeStreamSummaryResult> describeStreamSummaryAsync() {
        DescribeStreamSummaryRequest request = new DescribeStreamSummaryRequest();
        request.setStreamName(this.streamName);
        return this.kinesis.describeStreamSummaryAsync(request);
    }

    private void checkForStreamDescription() {
        DescribeStreamSummaryResult result;
        if (!this.describeStreamResult.isDone()) {
            return;
        }
        try {
            result = KinesisUtil.readResult(this.describeStreamResult);
        }
        catch (SdkClientException e) {
            this.dealWithDescribeStreamFailure(e);
            return;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow((Throwable)t);
        }
        finally {
            this.describeStreamResult = null;
        }
        this.describeStreamRetryTracker.reset();
        StreamDescriptionSummary streamDescription = result.getStreamDescriptionSummary();
        if (streamDescription == null) {
            return;
        }
        Integer newShardCount = streamDescription.getOpenShardCount();
        if (newShardCount == null) {
            return;
        }
        int oldShardCount = this.shardCount.getAndSet(newShardCount);
        if (oldShardCount != newShardCount) {
            this.logger.info(String.format("Updated shard count for stream '%s': %d", this.streamName, newShardCount));
        }
    }

    private void dealWithDescribeStreamFailure(@Nonnull Exception failure) {
        this.describeStreamRetryTracker.attemptFailed();
        if (!this.describeStreamRetryTracker.shouldTryAgain()) {
            throw ExceptionUtil.rethrow((Throwable)failure);
        }
        long timeoutMillis = this.describeStreamRetryTracker.getNextWaitTimeMillis();
        this.logger.warning(String.format("Failed obtaining stream description, retrying in %d ms. Cause: %s", timeoutMillis, failure.getMessage()));
        this.nextDescribeStreamTime = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(timeoutMillis);
    }

    @Nonnull
    private static RandomizedRateTracker initRandomizedTracker(int knownShardCountInstances) {
        return new RandomizedRateTracker(TimeUnit.SECONDS.toNanos(1L) * (long)knownShardCountInstances, 2);
    }
}

