/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.kinesis.impl.sink;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.util.counters.Counter;
import com.hazelcast.internal.util.counters.SwCounter;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.core.Inbox;
import com.hazelcast.jet.core.Outbox;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.Watermark;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.kinesis.impl.KinesisUtil;
import com.hazelcast.jet.kinesis.impl.RetryTracker;
import com.hazelcast.jet.kinesis.impl.sink.ShardCountMonitor;
import com.hazelcast.jet.kinesis.impl.sink.SleepController;
import com.hazelcast.jet.retry.RetryStrategy;
import com.hazelcast.logging.ILogger;
import com.hazelcast.shaded.com.amazonaws.SdkClientException;
import com.hazelcast.shaded.com.amazonaws.services.kinesis.AmazonKinesisAsync;
import com.hazelcast.shaded.com.amazonaws.services.kinesis.model.ProvisionedThroughputExceededException;
import com.hazelcast.shaded.com.amazonaws.services.kinesis.model.PutRecordsRequest;
import com.hazelcast.shaded.com.amazonaws.services.kinesis.model.PutRecordsRequestEntry;
import com.hazelcast.shaded.com.amazonaws.services.kinesis.model.PutRecordsResult;
import com.hazelcast.shaded.com.amazonaws.services.kinesis.model.PutRecordsResultEntry;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class KinesisSinkP<T>
implements Processor {
    private static final int MAX_RECORD_PER_SHARD_PER_SECOND = 1000;
    private static final int MAX_RECORDS_IN_REQUEST = 500;
    private static final int MIN_RECORDS_IN_REQUEST = 10;
    private static final int MAX_REQUEST_SIZE_IN_BYTES = 0x500000;
    @Nonnull
    private final AmazonKinesisAsync kinesis;
    @Nonnull
    private final String stream;
    @Nonnull
    private final ShardCountMonitor monitor;
    @Nonnull
    private final Buffer<T> buffer;
    @Probe(name="batchSize", unit=ProbeUnit.COUNT)
    private final Counter batchSizeMetric;
    @Probe(name="throttlingSleep", unit=ProbeUnit.MS)
    private final Counter sleepMetric = SwCounter.newSwCounter();
    private ILogger logger;
    private int shardCount;
    private int sinkCount;
    private Future<PutRecordsResult> sendResult;
    private long nextSendTime = System.nanoTime();
    private final RetryTracker sendRetryTracker;
    private final ThroughputController throughputController = new ThroughputController();

    public KinesisSinkP(@Nonnull AmazonKinesisAsync kinesis, @Nonnull String stream, @Nonnull FunctionEx<T, String> keyFn, @Nonnull FunctionEx<T, byte[]> valueFn, @Nonnull ShardCountMonitor monitor, @Nonnull RetryStrategy retryStrategy) {
        this.kinesis = kinesis;
        this.stream = stream;
        this.monitor = monitor;
        this.buffer = new Buffer<T>(keyFn, valueFn);
        this.batchSizeMetric = SwCounter.newSwCounter((long)this.buffer.getCapacity());
        this.sendRetryTracker = new RetryTracker(retryStrategy);
    }

    public boolean isCooperative() {
        return true;
    }

    public boolean closeIsCooperative() {
        return true;
    }

    public void init(@Nonnull Outbox outbox, @Nonnull Processor.Context context) {
        this.logger = context.logger();
        this.sinkCount = context.totalParallelism();
    }

    public boolean tryProcessWatermark(@Nonnull Watermark watermark) {
        return true;
    }

    public void process(int ordinal, @Nonnull Inbox inbox) {
        this.monitor.run();
        this.updateThroughputLimitations();
        if (this.sendResult != null) {
            this.checkIfSendingFinished();
        }
        if (this.sendResult == null) {
            this.initSending(inbox);
        }
    }

    public boolean complete() {
        if (this.sendResult != null) {
            this.checkIfSendingFinished();
        }
        if (this.sendResult == null) {
            if (this.buffer.isEmpty()) {
                return true;
            }
            this.initSending(null);
        }
        return false;
    }

    public boolean saveToSnapshot() {
        return this.complete();
    }

    private void updateThroughputLimitations() {
        int newShardCount = this.monitor.shardCount();
        if (newShardCount > 0 && this.shardCount != newShardCount) {
            this.buffer.setCapacity(this.throughputController.computeBatchSize(newShardCount, this.sinkCount));
            this.batchSizeMetric.set((long)this.buffer.getCapacity());
            this.shardCount = newShardCount;
        }
    }

    private void initSending(@Nullable Inbox inbox) {
        if (inbox != null) {
            this.bufferFromInbox(inbox);
        }
        this.attemptToDispatchBufferContent();
    }

    private void bufferFromInbox(@Nonnull Inbox inbox) {
        Object t;
        while ((t = inbox.peek()) != null && this.buffer.add(t)) {
            inbox.remove();
        }
    }

    private void attemptToDispatchBufferContent() {
        if (this.buffer.isEmpty()) {
            return;
        }
        long currentTime = System.nanoTime();
        if (currentTime < this.nextSendTime) {
            return;
        }
        List<PutRecordsRequestEntry> entries = this.buffer.content();
        this.sendResult = this.putRecordsAsync(entries);
        this.nextSendTime = currentTime;
    }

    private Future<PutRecordsResult> putRecordsAsync(Collection<PutRecordsRequestEntry> entries) {
        PutRecordsRequest request = new PutRecordsRequest();
        request.setRecords(entries);
        request.setStreamName(this.stream);
        return this.kinesis.putRecordsAsync(request);
    }

    private void checkIfSendingFinished() {
        if (this.sendResult.isDone()) {
            PutRecordsResult result;
            try {
                result = KinesisUtil.readResult(this.sendResult);
            }
            catch (ProvisionedThroughputExceededException pte) {
                this.dealWithThroughputExceeded("Data throughput rate exceeded. Backing off and retrying in %d ms");
                return;
            }
            catch (SdkClientException sce) {
                this.dealWithSendFailure(sce);
                return;
            }
            catch (Throwable t) {
                throw ExceptionUtil.rethrow((Throwable)t);
            }
            finally {
                this.sendResult = null;
            }
            this.pruneSentFromBuffer(result);
            if (result.getFailedRecordCount() > 0) {
                this.dealWithThroughputExceeded("Failed to send " + result.getFailedRecordCount() + " (out of " + result.getRecords().size() + ") record(s) to stream '" + this.stream + "'. Sending will be retried in %d ms, message reordering is likely.");
            } else {
                long sleepTimeNanos = this.throughputController.markSuccess();
                this.nextSendTime += sleepTimeNanos;
                this.sleepMetric.set(TimeUnit.NANOSECONDS.toMillis(sleepTimeNanos));
                this.sendRetryTracker.reset();
            }
        }
    }

    private void dealWithSendFailure(@Nonnull Exception failure) {
        this.sendRetryTracker.attemptFailed();
        if (!this.sendRetryTracker.shouldTryAgain()) {
            throw ExceptionUtil.rethrow((Throwable)failure);
        }
        long timeoutMillis = this.sendRetryTracker.getNextWaitTimeMillis();
        this.logger.warning(String.format("Failed to send records, will retry in %d ms. Cause: %s", timeoutMillis, failure.getMessage()));
        this.nextSendTime = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(timeoutMillis);
    }

    private void dealWithThroughputExceeded(@Nonnull String message) {
        long sleepTimeNanos = this.throughputController.markFailure();
        this.nextSendTime += sleepTimeNanos;
        this.sleepMetric.set(TimeUnit.NANOSECONDS.toMillis(sleepTimeNanos));
        this.logger.warning(String.format(message, TimeUnit.NANOSECONDS.toMillis(sleepTimeNanos)));
    }

    private void pruneSentFromBuffer(@Nullable PutRecordsResult result) {
        if (result == null) {
            return;
        }
        List<PutRecordsResultEntry> resultEntries = result.getRecords();
        if (result.getFailedRecordCount() > 0) {
            this.buffer.retainFailedEntries(resultEntries);
        } else {
            this.buffer.clear();
        }
    }

    private static final class ThroughputController
    extends SleepController {
        private static final int IDEAL_SLEEP_MS = 250;

        private ThroughputController() {
        }

        int computeBatchSize(int shardCount, int sinkCount) {
            if (shardCount < 1) {
                throw new IllegalArgumentException("Invalid shard count: " + shardCount);
            }
            if (sinkCount < 1) {
                throw new IllegalArgumentException("Invalid sink count: " + sinkCount);
            }
            int totalRecordsPerSecond = 1000 * shardCount;
            int recordPerSinkPerSecond = totalRecordsPerSecond / sinkCount;
            int computedBatchSize = recordPerSinkPerSecond / (int)(TimeUnit.SECONDS.toMillis(1L) / 250L);
            if (computedBatchSize > 500) {
                return 500;
            }
            return Math.max(computedBatchSize, 10);
        }
    }

    private static class Buffer<T> {
        private final FunctionEx<T, String> keyFn;
        private final FunctionEx<T, byte[]> valueFn;
        private final BufferEntry[] entries;
        private int entryCount;
        private int totalEntrySize;
        private int capacity;

        Buffer(FunctionEx<T, String> keyFn, FunctionEx<T, byte[]> valueFn) {
            this.keyFn = keyFn;
            this.valueFn = valueFn;
            this.entries = Buffer.initEntries();
            this.capacity = this.entries.length;
        }

        public int getCapacity() {
            return this.capacity;
        }

        void setCapacity(int capacity) {
            if (capacity < 0 || capacity > this.entries.length) {
                throw new IllegalArgumentException("Capacity limited to [0, " + this.entries.length + ")");
            }
            this.capacity = capacity;
        }

        boolean add(T item) {
            if (this.isFull()) {
                return false;
            }
            String key = (String)this.keyFn.apply(item);
            if (key.isEmpty()) {
                throw new JetException("Key empty");
            }
            int unicodeCharsInKey = key.length();
            if (unicodeCharsInKey > 256) {
                throw new JetException("Key too long");
            }
            int keyLength = this.getKeyLength(key);
            byte[] value = (byte[])this.valueFn.apply(item);
            int itemLength = value.length + keyLength;
            if (itemLength > 0x100000) {
                throw new JetException("Encoded length (key + payload) is too big");
            }
            if (this.totalEntrySize + itemLength > 0x500000) {
                return false;
            }
            this.totalEntrySize += itemLength;
            BufferEntry entry = this.entries[this.entryCount++];
            entry.set(key, value, itemLength);
            return true;
        }

        public void retainFailedEntries(List<PutRecordsResultEntry> results) {
            assert (results.size() == this.entryCount);
            int startIndex = 0;
            for (int index = 0; index < results.size(); ++index) {
                if (results.get(index).getErrorCode() != null) {
                    this.swap(startIndex++, index);
                    continue;
                }
                this.totalEntrySize -= this.entries[index].encodedSize;
                --this.entryCount;
            }
        }

        private void swap(int a, int b) {
            BufferEntry temp = this.entries[a];
            this.entries[a] = this.entries[b];
            this.entries[b] = temp;
        }

        void clear() {
            this.entryCount = 0;
            this.totalEntrySize = 0;
        }

        boolean isEmpty() {
            return this.entryCount == 0;
        }

        public boolean isFull() {
            return this.entryCount == this.entries.length || this.entryCount >= this.capacity;
        }

        public List<PutRecordsRequestEntry> content() {
            return Arrays.stream(this.entries).limit(this.entryCount).map(e -> e.putRecordsRequestEntry).collect(Collectors.toList());
        }

        private int getKeyLength(String key) {
            return key.length();
        }

        private static BufferEntry[] initEntries() {
            return (BufferEntry[])IntStream.range(0, 500).boxed().map(ignored -> new BufferEntry()).toArray(BufferEntry[]::new);
        }
    }

    private static final class BufferEntry {
        private PutRecordsRequestEntry putRecordsRequestEntry;
        private int encodedSize;

        private BufferEntry() {
        }

        public void set(String partitionKey, byte[] data, int size) {
            if (this.putRecordsRequestEntry == null) {
                this.putRecordsRequestEntry = new PutRecordsRequestEntry();
            }
            this.putRecordsRequestEntry.setPartitionKey(partitionKey);
            ByteBuffer byteBuffer = this.putRecordsRequestEntry.getData();
            if (byteBuffer == null || byteBuffer.capacity() < data.length) {
                this.putRecordsRequestEntry.setData(ByteBuffer.wrap(data));
            } else {
                ((java.nio.Buffer)byteBuffer).clear();
                byteBuffer.put(data);
                ((java.nio.Buffer)byteBuffer).flip();
            }
            this.encodedSize = size;
        }
    }
}

