/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.kinesis.impl;

import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;

public class RandomizedRateTracker {
    private final long[] parts;
    private int index;

    public RandomizedRateTracker(long duration, int n) {
        this.parts = RandomizedRateTracker.init(duration, n);
    }

    public long next() {
        long part = this.parts[this.index++];
        if (this.index == this.parts.length) {
            this.index = 0;
        }
        return part;
    }

    private static long[] init(long total, int n) {
        long[] parts = new long[n];
        ThreadLocalRandom random = ThreadLocalRandom.current();
        long base = total / (long)n;
        long remaining = total;
        for (int i = 0; i < n - 1; ++i) {
            long part = random.nextLong(base / 2L, 3L * base / 2L);
            remaining -= part;
            parts[i] = part;
        }
        parts[n - 1] = remaining;
        return parts;
    }

    public String toString() {
        return Arrays.stream(this.parts).boxed().map(Object::toString).collect(Collectors.joining(", "));
    }
}

