/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.utils;

import com.hazelcast.webmonitor.utils.PlatformUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExtractUtil {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExtractUtil.class);
    public static final Set<PosixFilePermission> ALL_GRANTED_PERMISSION = Set.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_WRITE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_WRITE, PosixFilePermission.OTHERS_EXECUTE);
    public static final Set<PosixFilePermission> RW_PERMISSION = Set.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_WRITE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_WRITE);

    private ExtractUtil() {
    }

    public static boolean unzip(InputStream is, Path destination, Map<String, Set<PosixFilePermission>> permissions) {
        boolean bl;
        ZipInputStream archiveInputStream = new ZipInputStream(is);
        try {
            ZipEntry entry;
            while ((entry = archiveInputStream.getNextEntry()) != null) {
                Path extractTo = destination.resolve(entry.getName());
                if (entry.isDirectory()) {
                    Files.createDirectories(extractTo, new FileAttribute[0]);
                    continue;
                }
                Files.copy(archiveInputStream, extractTo, new CopyOption[0]);
                Set permission = permissions.get(entry.getName());
                if (permission == null) {
                    permission = ALL_GRANTED_PERMISSION;
                }
                if (PlatformUtil.getOS() == PlatformUtil.OS.WINDOWS) {
                    File file = new File(extractTo.toAbsolutePath().toString());
                    file.setExecutable(permission.contains((Object)PosixFilePermission.OWNER_EXECUTE));
                    file.setReadable(permission.contains((Object)PosixFilePermission.OWNER_READ));
                    file.setWritable(permission.contains((Object)PosixFilePermission.OWNER_WRITE));
                    continue;
                }
                Files.setPosixFilePermissions(extractTo, permission);
            }
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    archiveInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        archiveInputStream.close();
        return bl;
    }
}

